<div class="row">
    <div class="col-12">
        <div class="card card-dark bg-dark py-1">
            <div class="card-body p-4">
                <div class="row">
                    <div class="col-md-4 py-5">
                        <div class="h5"><?php echo e(__('Profile Information')); ?></div>
                        <p class=""><?php echo e(__('Update your account profile information.')); ?></p>
                    </div>
                    <div class="col-md-8">
                        <form action="<?php echo e(route('admin.profile-update')); ?>" method="post" enctype="multipart/form-data"
                            class="wma-form">
                            <?php echo csrf_field(); ?>
                            <div class="">
                                <p class="h6 mb-3"><?php echo e(__('Photo')); ?></p>
                                <div class="row">
                                    <div class="col-md-6 text-center">
                                        <?php if(Auth::user()->getAttributes()['profile_photo_path'] != null): ?>
                                            <?php echo imageShow(asset(UPLOAD_FOLDER_USER.Auth::user()->getAttributes()['profile_photo_path']), Auth::user()->name, 'rounded-circle', 'width="150" height="150"'); ?>

                                        <?php else: ?>
                                            <img src="<?php echo e(Auth::user()->gender == 'male' ? asset('backend/assets/img/profile/male.jpg') : (Auth::user()->gender == 'female' ? asset('backend/assets/img/profile/female.jpg') : asset('backend/assets/img/profile/other.png'))); ?>"
                                                class="rounded-circle " width="150">
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="">
                                            <div class="admin-image" id="admin_image">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-3">
                                    <div class="col">
                                        <p class="mb-1 font-weight-bold"><label for="name"><?php echo e(__('Name')); ?>:</label>
                                        </p>
                                        <div class="input-group input-group-lg mb-3">
                                            <input type="text" name="name" id="name" value="<?php echo e(Auth::user()->name); ?>"
                                                class="form-control rounded" aria-label="Large"
                                                placeholder="<?php echo e(__('Name in English')); ?>"
                                                aria-describedby="inputGroup-sizing-sm">
                                            <br>
                                            <?php if($errors->has('name')): ?>
                                                <span class="text-danger"><?php echo e($errors->first('name')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        <p class="mb-1 font-weight-bold"><label
                                                for="email"><?php echo e(__('Email')); ?>:</label> </p>
                                        <div class="input-group input-group-lg mb-3">
                                            <input type="email" name="email" id="email"
                                                value="<?php echo e(Auth::user()->email); ?>" class="form-control rounded"
                                                aria-label="Large" aria-describedby="inputGroup-sizing-sm">
                                            <br>
                                            <?php if($errors->has('email')): ?>
                                                <span class="text-danger"><?php echo e($errors->first('email')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="pageContent">
                                                <span
                                                    class="d-block card-title mb-1 font-weight-bold"><?php echo e(__('Description :')); ?>

                                                </span>
                                            </label>
                                            <textarea name="about_me" id="about_me" rows="5" class="form-control "
                                                placeholder="<?php echo e(__('About Me...')); ?>"><?php echo e(auth()->user()->about_me); ?></textarea>
                                            <?php $__errorArgs = ['about_me'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        
                                    </div>
                                </div>
                                <div class="float-right">
                                    <button class="btn btn-wave-light rounded btn-danger btn-lg"
                                        type="submit"><?php echo e(__('Save')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/profile/update-profile-information-form.blade.php ENDPATH**/ ?>