<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <title><?php echo $__env->yieldContent('title'); ?></title>
        <!-- Fonts -->
        <link href="https://fonts.googleapis.com/css2?family=Nunito&display=swap" rel="stylesheet">
        <link rel="stylesheet" href="<?php echo e(asset('css/error.css')); ?>">
    </head>
    <body class="antialiased font-sans">
        <div class="md:flex min-h-screen">
            <div class="w-full bg-white flex items-center justify-center text-center">
                <div class="max-w-sm m-8">
                    <div class="text-black text-5xl md:text-15xl font-black">
                        <?php echo $__env->yieldContent('code', __('Oh no')); ?>
                    </div>
                    <div class="w-full h-1 bg-purple-light my-3 md:my-6"></div>
                    <p class="text-grey-darker text-2xl md:text-3xl font-light mb-8 leading-normal text-center">
                        <?php echo $__env->yieldContent('message'); ?>
                    </p>
                    <a href="<?php echo e(app('router')->has('home') ? route('home') : url('/')); ?>">
                        <button class="bg-transparent text-grey-darkest font-bold uppercase tracking-wide py-3 px-6 border-2 border-grey-light hover:border-grey rounded-lg">
                            <?php echo e(__('Go Home')); ?>

                        </button>
                    </a>
                </div>
            </div>
        </div>
    </body>
</html>
<?php /**PATH /home/www/bdctravel.bdcoder.com/resources/views/errors/illustrated-layout.blade.php ENDPATH**/ ?>