

<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>

<?php $__env->startSection('page-css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Slick Section Start -->
    <?php if($slider_setting): ?>
        <section class="slider-wrapper st-two p-0">
            <div id="slider-style-one" class="carousel slide bs-slider control-round indicators-line" data-ride="carousel"
                data-pause="hover" data-interval="5000">
                <!-- Indicators -->
                <ol class="carousel-indicators">
                    <?php for($i = 0; $i < count($sliders); $i++): ?>
                        <li data-target="#slider-style-one" data-slide-to="<?php echo e($i); ?>" <?php if($i == 0): ?> class="active" <?php endif; ?>>
                        </li>
                    <?php endfor; ?>
                </ol>
                <!-- Wrapper For Slides -->
                <div class="carousel-inner" role="listbox">
                    <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skey => $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <!-- Item Slide -->
                        <div class="carousel-item <?php echo e($skey == 0 ? 'active' : ''); ?>">

                            <!-- Slide Background -->
                            <?php echo imageShow($slider->bg_image, 'Slider Images', 'slide-image'); ?>

                            <div class="bs-slider-overlay"></div>
                            <div class="container">
                                <div class="row">
                                    <!-- Slide Text Layer -->
                                    <div class="slide-text slide-style-left st-two">
                                        <h1><?php echo e(clean($slider ? $slider->title : '')); ?></h1>
                                        <h2><?php echo e(clean($slider ? $slider->sub_title : '')); ?></h2>
                                    </div>
                                    <!-- Package Box -->
                                    <div class="package-box">
                                        <?php echo $slider->description; ?>

                                        <a href="<?php echo e($slider->button_url); ?>"><?php echo e($slider->button_name); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <!-- End of Slide -->
                </div><!-- End of Wrapper For Slides -->
                <!-- Left Control -->
                <a class="left carousel-control" href="#slider-style-one" role="button" data-slide="prev">
                    <span class="fa fa-angle-left" aria-hidden="true"></span>
                    <span class="sr-only"><?php echo e(__('Previous')); ?></span>
                </a>
                <!-- Right Control -->
                <a class="right carousel-control" href="#slider-style-one" role="button" data-slide="next">
                    <span class="fa fa-angle-right" aria-hidden="true"></span>
                    <span class="sr-only"><?php echo e(__('Next')); ?></span>
                </a>
            </div> <!-- End  slider-style-one Slider -->
        </section>
        <!-- Slick Section End -->
    <?php endif; ?>
    <!-- Welcome Section Start -->
    <?php if($slider_setting): ?>
    <section class="welcome-section">
        <div class="container">
            <?php echo $slider_setting?$slider_setting->description:''; ?>

        </div>
    </section>
    <?php endif; ?>
    <!-- Welcome Section End -->

    <!-- Special Places Section Start -->
    <?php if($place_setting && count($places)): ?>
        <section class="special-places-sec pb-80">
            <div class="container">
                <div class="row">
                    <div class="section-title">
                        <?php if($place_setting->title): ?><h4><?php echo e(clean($place_setting->title)); ?></h4><?php endif; ?>
                        <?php if($place_setting->sub_title): ?><h2><?php echo e(clean($place_setting->sub_title)); ?></h2><?php endif; ?>
                        <?php if($place_setting->description): ?><p><?php echo e(clean($place_setting->description)); ?></p><?php endif; ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="tab-style">
                            <nav>
                                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                    <?php if(count($places)): ?>
                                        <?php $__currentLoopData = $places; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pkey => $place): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a class="nav-item nav-link <?php echo e($pkey == 0 ? 'active' : ''); ?>"
                                                id="plc-<?php echo e($place->id); ?>-tab" data-toggle="tab"
                                                href="#plc-<?php echo e($place->id); ?>" role="tab"
                                                aria-controls="plc-<?php echo e($place->id); ?>"
                                                aria-selected="true"><?php echo e($place->name); ?></a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                            </nav>
                            <div class="tab-content" id="nav-tabContent">
                                <!-- item start -->
                                <?php if(count($places)): ?>
                                    <?php $__currentLoopData = $places; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pakey => $place): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="tab-pane fade <?php echo e($pakey == 0 ? 'show active' : ''); ?>"
                                            id="plc-<?php echo e($place->id); ?>" role="tabpanel"
                                            aria-labelledby="plc-<?php echo e($place->id); ?>-tab">
                                            <div class="specialplaces_carousel owl-carousel owl-theme owl-navst st-two">
                                                <?php $__currentLoopData = $place->package; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $place_package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php
                                                        $discount = $place_package->discount ? $place_package->discount->discount : null;
                                                        $subprices = $place_package->subprice ? $place_package->subprice : null;
                                                    ?>
                                                    <div class="item">
                                                        <div class="special-places">
                                                            <?php if(count($place_package->images)): ?>
                                                                <div class="thumb">
                                                                    <a href="<?php echo e(route('package.details', $place_package->id)); ?>">
                                                                        <?php echo imageShow($place_package->images[0]->images, 'upload/pkg_image/', __('Tour Image'), ''); ?>

                                                                    </a>
                                                                </div>
                                                            <?php endif; ?>

                                                            <div class="content">
                                                                <div class="price-box">
                                                                    <h5><?php echo e(currencyFormat($place_package->price)); ?>

                                                                    </h5>
                                                                    <h6><?php echo e(__('Starts From')); ?></h6>
                                                                </div>
                                                                <div class="title-box">
                                                                    <h4><a href="<?php echo e(route('package.details', $place_package->id)); ?>"><?php echo e(Str::limit($place_package->title, 50)); ?></a></h4>
                                                                    <h3><?php echo e($place_package->location); ?></h3>
                                                                </div>
                                                                <ul class="info">
                                                                    <li><span><i
                                                                                class="fa fa-calendar"></i><?php echo e($place_package->day); ?>

                                                                            <?php echo e(__('Days')); ?></span>
                                                                    </li>
                                                                    <li><span><i
                                                                                class="fa fa-user"></i><?php echo e($subprices && $subprices[0] ? $subprices[0]->group_size : ''); ?></span>
                                                                    </li>
                                                                    <?php if($place_package->tour_map_image): ?>
                                                                        <li><a class="package_map"
                                                                                href="#package_map_modal"
                                                                                data-toggle="modal"
                                                                                data-name="<?php echo e($place_package->title); ?>"
                                                                                data-image="<?php echo e(imageShow($place_package->tour_map_image, 'Package Image')); ?>"><i
                                                                                    class="fa fa-map-marker"></i><?php echo e(__('View Map Image')); ?></a>
                                                                        </li>
                                                                    <?php endif; ?>
                                                                </ul>
                                                                <p><?php echo e(clean(Str::limit($place_package ? $place_package->description : '',135))); ?>

                                                                </p>
                                                                <h5 class="share-btn"><i class="fa fa-share-alt"
                                                                        data-toggle="dropdown" aria-expanded="false"></i>
                                                                    <div class="dropdown-menu">
                                                                        <?php echo $__env->make('frontend.share-link',['route'=>route('package.details', $place_package->id)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                                    </div>
                                                                </h5>
                                                                <a class="btn-theme"
                                                                    href="<?php echo e(route('package.details', $place_package->id)); ?>"><?php echo e(__('View Details')); ?></a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                <!-- item end -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Special Places Section End -->
    <?php endif; ?>

    <?php if($feature_setting && count($features)): ?>
        <!-- Features Section Start -->
        <section class="feature-section over-layer-black pt-85 pb-90" <?php if($feature_setting && $feature_setting->fnt_img): ?> style="background-image: url('<?php echo e($feature_setting->fnt_img); ?>')"  <?php endif; ?>>
            <div class="container">
                <div class="row">
                    <div class="section-title">
                        <h4><?php echo e(clean($feature_setting ? $feature_setting->title : '')); ?></h4>
                        <h2><?php echo e(clean($feature_setting ? $feature_setting->sub_title : '')); ?></h2>
                        <p><?php echo e(clean($feature_setting ? $feature_setting->description : '')); ?></p>
                    </div>
                </div>
                <div class="row">
                    <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4">
                            <div class="feature-item">
                                <div class="icon-box">
                                    <?php echo clean($feature ? $feature->icon : ''); ?>

                                </div>
                                <div class="content">
                                    <h3><?php echo e(clean($feature ? $feature->title : '')); ?></h3>
                                    <p><?php echo e(clean($feature ? $feature->description : '')); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
        <!-- Feature Section End -->
    <?php endif; ?>

    <?php if($spacial_package_setting && count($spacial_packages)): ?>
        <!-- Special Packages Section Start -->
        <section class="special-packages-sec pt-85 pb-90">
            <div class="container">
                <div class="row">
                    <div class="col-md-9">
                        <div class="section-title stitle-left">
                            <h4><?php echo e(clean($spacial_package_setting ? $spacial_package_setting->title : '')); ?></h4>
                            <h2><?php echo e(clean($spacial_package_setting ? $spacial_package_setting->sub_title : '')); ?></h2>
                            <p><?php echo e(clean($spacial_package_setting ? $spacial_package_setting->description : '')); ?></p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="<?php if($spacial_package_discount): ?> col-lg-9 <?php else: ?> col-lg-12 <?php endif; ?>">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="specialpackages_carousel owl-carousel owl-theme owl-navst">
                                    <?php $__currentLoopData = $spacial_packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $spacial_package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $discount = $spacial_package->discount ? $spacial_package->discount->discount : null;
                                            $subprices = $spacial_package->subprice ? $spacial_package->subprice : null;
                                            $package_images = $spacial_package->images;
                                        ?>
                                        <div class="item">
                                            <div class="special-packages">
                                                <div class="thumb">
                                                    <?php if(count($package_images)): ?>
                                                    <a href="<?php echo e(route('package.details', $spacial_package->id)); ?>">
                                                        <?php echo imageShow($package_images[0]->images, __('Tour Image'), ''); ?>

                                                    </a>
                                                    <?php endif; ?>

                                                    <?php if($discount): ?>
                                                        <div class="offer-price"> <?php echo e(__('Off')); ?>

                                                            <?php echo e(discountPriceShow($discount)); ?>

                                                        </div>
                                                    <?php endif; ?>

                                                    <div class="post-title-box">
                                                        <div class="price-box">
                                                            <h5><?php echo e(currencyFormat($spacial_package->price)); ?>

                                                            </h5>
                                                            <h6><?php echo e(__('Starts From')); ?></h6>
                                                        </div>
                                                        <div class="title-box">
                                                            <a href="<?php echo e(route('package.details', $spacial_package->id)); ?>">
                                                                <h4>
                                                                    <?php echo e(Str::limit($spacial_package->title, 50)); ?>

                                                                </h4>
                                                            </a>
                                                            <h3><?php echo e($spacial_package->location); ?></h3>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="content">
                                                    <ul class="info">
                                                        <li><span><i
                                                                    class="fa fa-calendar"></i>&nbsp;<?php echo e($spacial_package->day); ?>

                                                                <?php echo e(__('Days')); ?></span></li>
                                                        <li><span><i
                                                                    class="fa fa-user"></i>&nbsp;<?php echo e($subprices && $subprices[0] ? $subprices[0]->group_size : ''); ?></span>
                                                        </li>
                                                        <?php if($spacial_package->tour_map_image): ?>
                                                            <li><a class="package_map" href="#package_map_modal"
                                                                    data-toggle="modal"
                                                                    data-name="<?php echo e($spacial_package->title); ?>"
                                                                    data-image="<?php echo e(imageShow($spacial_package->tour_map_image, 'Package Image')); ?>"><i
                                                                        class="fa fa-map-marker"></i><?php echo e(__('View Map Image')); ?></a>
                                                            </li>
                                                        <?php endif; ?>
                                                    </ul>
                                                    <p><?php echo e(clean(Str::limit($spacial_package->description,135))); ?></p>
                                                    <div class="small-hotel">

                                                        <div class="thumb">
                                                            <?php if($package_images): ?>
                                                                <?php $__currentLoopData = $package_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php echo imageShow($image->images, __('Tour Image'), ''); ?>&nbsp;
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                    <h5 class="share-btn"><i class="fa fa-share-alt"
                                                            data-toggle="dropdown" aria-expanded="false"></i>
                                                        <div class="dropdown-menu">
                                                            <?php echo $__env->make('frontend.share-link',['route'=>route('package.details', $spacial_package->id)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                        </div>
                                                    </h5>
                                                    <a class="btn-theme"
                                                        href="<?php echo e(route('package.details', $spacial_package->id)); ?>"><?php echo e(__('View Details')); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if($spacial_package_discount): ?>
                        <div class="col-lg-3">
                            <div class="add-box thumb">
                                <a href="<?php echo e(route('discount.details', $spacial_package_discount->id)); ?>">
                                    <?php echo imageShow($spacial_package_discount->images, __('Discount'), ''); ?>

                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
        <!-- Special Packages Section End -->
    <?php endif; ?>

    <?php if($award_setting): ?>
        <!-- Funfact Section Start -->
        <section class="funfact-section over-layer-black pt-90 pb-60">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="video-sec">
                            <h2><?php echo e(clean($award_setting ? $award_setting->title : '')); ?></h2>
                            <p><?php echo e(clean($award_setting ? $award_setting->sub_title : '')); ?></p>
                            <div class="video-content">
                                <?php echo imageShow($award_setting->fnt_img, __('Award Image')); ?>

                                <?php if($award_setting->youtube_url): ?>
                                    <div class="overlay">
                                        <a href="<?php echo e($award_setting->youtube_url); ?>" class="popup-youtube"><i
                                                class="ficon fa fa-play-circle"></i></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <?php echo clean($award_setting ? $award_setting->description : ''); ?>

                    </div>
                </div>
            </div>
        </section>
        <!-- Funfact Section End -->
    <?php endif; ?>


    <?php if($hotel_setting): ?>
        <!-- Latest Hotel Section Start -->
        <section class="latest-hotel-sec pt-85 pb-80">
            <div class="container">
                <div class="row">
                    <div class="section-title">
                        <h4><?php echo e(clean($hotel_setting ? $hotel_setting->title : '')); ?></h4>
                        <h2><?php echo e(clean($hotel_setting ? $hotel_setting->sub_title : '')); ?></h2>
                        <p><?php echo e(clean($hotel_setting ? $hotel_setting->description : '')); ?></p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="latesthotel_carousel owl-carousel owl-theme owl-navst">
                            <?php $__currentLoopData = $hotels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hotel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="item">
                                    <div class="latest-hotel">
                                        <div class="thumb">
                                            <a href="<?php echo e(route('single-hotel', $hotel->id)); ?>">
                                                <?php echo imageShow(asset(UPLOAD_FOLDER_HOTELS.$hotel->feature_image), __('Hotel Image')); ?>

                                            </a>
                                        </div>
                                        <div class="content">
                                            <a href="<?php echo e(route('single-hotel', $hotel->id)); ?>">
                                                <h4><?php echo e(clean($hotel ? $hotel->hotel_name : '')); ?></h4>
                                            </a>
                                            <h5><?php echo e(clean(Str::limit($hotel ? $hotel->hotel_location : '',40))); ?></h5>
                                            <p><?php echo e(Str::limit(clean($hotel ? $hotel->description : ''), 70)); ?></p>
                                            <a class="map-viw hotel_map" href="#hotel_map_modal" data-toggle="modal"
                                                data-lat="<?php echo e($hotel->latitude); ?>" data-lng="<?php echo e($hotel->longitude); ?>"
                                                data-name="<?php echo e($hotel->hotel_name); ?>"><i
                                                    class="fa fa-map-marker"></i><?php echo e(__('View on Map')); ?></a>
                                                <?php if($hotel->price): ?>
                                                    <p class="price"><?php echo e(__('One Night Price')); ?>: <?php echo e(currencyFormat($hotel->price)); ?></p>
                                                <?php endif; ?>
                                            <a class="btn-theme"
                                               href="<?php echo e(route('single-hotel', $hotel->id)); ?>"><?php echo e(__('Book now')); ?></a>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php echo $__env->make('frontend.pages.hotel.map-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Latest Hotel Section End -->
    <?php endif; ?>

    <?php if($about_setting): ?>
        <!-- Global Section Start -->
        <section class="global-section over-layer-white pt-80 pb-70">
            <div class="container">
                <div class="row">
                    <div class="col-xl-7 col-lg-12">
                        <div class="global-area">
                            <div class="inner-title">
                                <h2><?php echo e(clean($about_setting ? $about_setting->title : '')); ?></h2>
                                <h3><?php echo e(clean($about_setting ? $about_setting->sub_title : '')); ?></h3>
                                <div class="sec-line"></div>
                            </div>
                            <?php echo clean($about_setting ? $about_setting->description : ''); ?>

                        </div>
                    </div>
                    <div class="col-xl-5 col-lg-8 col-md-10">
                        <?php if($about_setting && $about_setting->fnt_img): ?>
                            <div class="map-area">
                                <?php echo imageShow($about_setting->fnt_img, __('Image')); ?>

                            </div>
                        <?php endif; ?>
                        <p class="map-content"><?php echo e(clean($about_setting ? $about_setting->about_image_phone : '')); ?>

                        </p>
                    </div>
                </div>
            </div>
        </section>
        <!-- Global Section End -->
    <?php endif; ?>


    <?php if($gallery_setting): ?>
        <!-- Gallery Section Start -->
        <section class="gallery-section pt-85 pb-0">
            <div class="container-fluid">
                <div class="row">
                    <div class="section-title">
                        <h4><?php echo e(clean($gallery_setting ? $gallery_setting->title : '')); ?></h4>
                        <h2><?php echo e(clean($gallery_setting ? $gallery_setting->sub_title : '')); ?></h2>
                        <p><?php echo e(clean($gallery_setting ? $gallery_setting->description : '')); ?></p>
                    </div>
                </div>
                <div class="row gallery-items">
                    <?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-sm-4 col-grid">
                            <div class="gallery-item">
                                <div class="thumb">
                                    <?php echo imageShow($gallery->image, __('Image')); ?>

                                    <div class="overlay">
                                        <div class="inner">
                                            <a href="<?php echo e($gallery->image); ?>" class="icon lightbox-image">
                                                <i class="fa fa-plus"></i>
                                            </a>
                                            <h4><?php echo e(clean($gallery ? $gallery->title : '')); ?></h4>
                                            <p><?php echo e(__('Tour, Travel')); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
        <!-- Gallery Section End -->
    <?php endif; ?>


    <?php if($testimonial_setting): ?>
        <!-- Testimonials Section Start -->
        <section class="testimonials-section pt-80 pb-80">
            <div class="container">
                <div class="row">
                    <?php if(isset($left_side_testimonial)): ?>
                    <div class="col-lg-5">
                        <div class="testimonial-video mt-0">
                            <h5 style="font-family: Lora, Bangla304, serif;"><?php echo e(__('Latest Hotel Reviews')); ?></h5>
                            <div class="sec-line mb-20"></div>
                            <h3 style="font-family: Lora, Bangla304, serif;"><i class="fa fa-quote-left" style="font-family: FontAwesome, Bangla304, sans-serif;"></i> <?php echo e(Str::words($left_side_testimonial->testimonial, 25, ' ...')); ?></h3>
                            <?php if($left_side_testimonial->video_link): ?>
                                <a class="btn-theme popup-youtube" href="<?php echo e($left_side_testimonial->video_link); ?>"><i class="fa fa-play-circle" style="font-family: FontAwesome, Bangla304, sans-serif;"></i> <?php echo e(__('Play Video')); ?></a>
                            <?php endif; ?>
                            <div class="review-ratings">
                                <?php echo ratingShowDark($left_side_testimonial->rating); ?>

                                <a class="ratings-count" href="#">(<?php echo e($left_side_testimonial->rating); ?> <?php echo e(__('Ratings')); ?>)</a>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="<?php if(isset($left_side_testimonial)): ?> col-lg-7 <?php else: ?> col-lg-12 <?php endif; ?>">
                        <div class="inner-title mt-25">
                            <h2><?php echo e(clean($testimonial_setting ? $testimonial_setting->title : '')); ?></h2>
                            <div class="sec-line mb-40"></div>
                        </div>
                        <div class="testimonials-post testimonials_slide owl-carousel owl-theme owl-navst st-three">
                            <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="testimonials-item">
                                    <div class="thumb">
                                        <?php echo imageShow($testimonial->image, __('Reviewer Photo')); ?>

                                    </div>
                                    <div class="content">
                                        <h5><?php echo e(clean($testimonial ? $testimonial->name : '')); ?> <small>-
                                                <?php echo e(clean($testimonial ? $testimonial->designation : '')); ?></small></h5>
                                        <?php echo ratingShow($testimonial->rating); ?>

                                        <p><i class="fa fa-quote-left"></i>
                                            <?php echo e(clean($testimonial ? $testimonial->testimonial : '')); ?>

                                        </p>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Testimonials Section End -->
    <?php endif; ?>


    <?php if($promotional_setting): ?>
        <!-- App Section Start -->
        <section class="app-section over-layer-white pt-80 pb-90" style="<?php if(!empty($promotional_setting->bg_img)): ?>background-image: url(<?php echo e($promotional_setting->bg_img); ?>);<?php else: ?> background-image: url(<?php echo e(asset('frontend/images/bg/px-1.jpg')); ?>); <?php endif; ?>">
            <div class="container">
                <div class="row">
                    <div class="col-lg-10 offset-lg-1">
                        <div class="inner-title title-center">
                            <h2><?php echo e(clean($promotional_setting ? $promotional_setting->title : '')); ?></h2>
                            <h3><?php echo e(clean($promotional_setting ? $promotional_setting->sub_title : '')); ?></h3>
                            <div class="sec-line line-center"></div>
                        </div>
                        <p><?php echo e(clean($promotional_setting ? $promotional_setting->description : '')); ?></p>
                        <a class="btn-theme"
                            href="<?php echo e(clean($promotional_setting ? $promotional_setting->btn_1_url : '')); ?>"><?php echo e(clean($promotional_setting ? $promotional_setting->btn_1 : '')); ?></a>
                        <a class="btn-theme btn-two"
                            href="<?php echo e(clean($promotional_setting ? $promotional_setting->btn_2_url : '')); ?>"><?php echo e(clean($promotional_setting ? $promotional_setting->btn_2 : '')); ?></a>
                    </div>
                </div>
            </div>
        </section>
        <!-- App Section End -->
    <?php endif; ?>

    <?php if($blog_setting): ?>
        <!-- Blog Section Start -->
        <section class="blog-section bg-f8 pt-85 pb-55">
            <div class="container">
                <div class="row">
                    <div class="section-title">
                        <h4><?php echo e(clean($blog_setting ? $blog_setting->title : '')); ?></h4>
                        <h2><?php echo e(clean($blog_setting ? $blog_setting->sub_title : '')); ?></h2>
                        <p><?php echo e(clean($blog_setting ? $blog_setting->description : '')); ?></p>
                    </div>
                </div>
                <div class="row">
                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 col-lg-4">
                            <div class="blog-post">
                                <div class="thumb">
                                    <a href="<?php echo e(route('view-single-blog-page', ['slug' => $blog->slug])); ?>">
                                        <?php echo imageShow($blog->feature_img, __('Blog Image')); ?>

                                    </a>
                                    <div class="content">
                                        <a href="<?php echo e(route('view-single-blog-page', ['slug' => $blog->slug])); ?>">
                                            <h3><?php echo e($blog ? $blog->title : ''); ?></h3>
                                        </a>
                                        <div class="meta-box">
                                            <div class="admin-post"> <?php echo e((isset($blog->userId)) ? $blog->userId->name : ''); ?> </div>
                                            <div class="inner">
                                                <div class="date">
                                                    <i class="fa fa-calendar-plus-o"></i>
                                                    <?php echo e(date('M', strtotime($blog->created_at))); ?>

                                                    <b><?php echo e(date('d', strtotime($blog->created_at))); ?></b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <a href="<?php echo e(route('view-single-blog-page', ['slug' => $blog->slug])); ?>"
                                    class="read-btn"><?php echo e(__('Continue Reading')); ?>

                                    <i class="fa fa-long-arrow-right" aria-hidden="true"></i>
                                </a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
        <!-- Blog Section End -->
    <?php endif; ?>

    <?php if(($spacial_package_setting && count($spacial_packages)) || ($place_setting && count($places))): ?>
        <?php echo $__env->make('frontend.pages.packages.map-image-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <?php if($hotel_setting): ?>
        <?php echo $__env->make('frontend.scripts.map-script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
    <?php if(($spacial_package_setting && count($spacial_packages)) || ($place_setting && count($places))): ?>
        <?php echo $__env->make('frontend.scripts.package-map-script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/www/bdctravel.bdcoder.com/resources/views/welcome.blade.php ENDPATH**/ ?>