

<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>

<?php $__env->startSection('page-css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/images-grid.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" style="<?php if(!empty($pageContent->bg_img)): ?>background-image: url(<?php echo e($pageContent->bg_img); ?>);<?php else: ?> background-image: url(<?php echo e(asset('frontend/images/bg/px-1.jpg')); ?>); <?php endif; ?>" data-type="parallax" data-speed="3">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(isset($title) ? $title : ''); ?></h4>
                        <p><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Home')); ?></a>
                            <a><?php echo e(isset($title) ? $title : ''); ?></a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    <!-- Special Packages Section Start -->
    <section class="special-packages-sec pt-85 pb-60">
        <div class="container">
            <div class="row grid-mb">
                <div class="col-md-12">
                    <div class="special-packages dtl-st">
                        <div class="thumb">

                            <?php echo imageShow($hotel->hotel_primary_image, __('Hotel Image'), ''); ?>

                            <?php if($discount): ?>
                                <div class="offer-price"> <?php echo e(__('Off')); ?> <?php echo e(discountPriceShow($discount)); ?></div>
                            <?php endif; ?>

                            <div class="post-title-box">
                                <div class="price-box">
                                    <h5><?php echo e($hotel->hotelAccomodation ? discountPriceCalculate($hotel->hotelAccomodation->min('price'), $discount)['price'] : ''); ?>

                                    </h5>
                                    <h6><?php echo e(__('Starts From')); ?></h6>
                                </div>
                                <div class="title-box">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <h4><?php echo e(clean($hotel ? $hotel->hotel_name : '')); ?></h4>
                                            <h3><?php echo e(clean($hotel ? $hotel->hotel_location : '')); ?></h3>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="row">
                                                <div class="col-md-8 pt-2 ">
                                                    <h5 class="btn text-white pl-100"><i class="fa fa-share-alt pt-2 pb-2 text-danger"
                                                                                  data-toggle="dropdown" aria-expanded="false"></i>
                                                        <div class="dropdown-menu">
                                                            <?php echo $__env->make('frontend.share-link',['route'=>route('single-hotel', $hotel->id)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                        </div>
                                                    </h5>
                                                </div>
                                                <div class="col-md-4 pt-2">
                                                    <a class="btn btn-primary scroll_to_div" data-id="accommodation_section"
                                                       href="javascipt:void()"><?php echo e(__('Booking Now')); ?></a>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="content">
                            <ul class="info">
                                <div class="row">
                                <div class="col-md-6">
                                    <li><?php echo e($hotel->hotel_location); ?></li>
                                </div>
                                <div class="col-md-6 text-right">
                                    <li><a class="hotel_map" href="#hotel_map_modal" data-toggle="modal"
                                           data-lat="<?php echo e($hotel->latitude); ?>" data-lng="<?php echo e($hotel->longitude); ?>"
                                           data-name="<?php echo e($hotel->hotel_name); ?>"><i class="fa fa-map-marker"></i>
                                            <?php echo e(__('View on Map')); ?></a></li>
                                </div>
                                </div>
                            </ul>
                            <p><?php echo e(clean($hotel ? $hotel->description : '')); ?></p>

                            <div class="small-hotel">
                                <div id="gallery"></div>
                            </div>

                            <div class="inner-title mt-25">
                                <h2><?php echo e(clean($hotel?$hotel->hotel_to_stay_title:'')); ?></h2>
                                <div class="sec-line mb-15"></div>
                                <p><?php echo e(clean($hotel?$hotel->hotel_to_stay_description:'')); ?></p>
                            </div>
                            <div class="inner-title mt-25">
                                <div class="row">
                                    <div class="col-md-4">
                                        <h2><?php echo e(__('Brackfast Info')); ?></h2>
                                        <div class="sec-line mb-15"></div>
                                        <p><?php echo e(clean($hotel?$hotel->breakfast_info:'')); ?></p>
                                    </div>
                                    <div class="col-md-4">
                                        <h2><?php echo e(__('Lunch Info')); ?></h2>
                                        <div class="sec-line mb-15"></div>
                                        <p><?php echo e(clean($hotel?$hotel->lunch_info:'')); ?></p>
                                    </div>
                                    <div class="col-md-4">
                                        <h2><?php echo e(__('Dinner Info')); ?></h2>
                                        <div class="sec-line mb-15"></div>
                                        <p><?php echo e(clean($hotel?$hotel->dinner_info:'')); ?></p>
                                    </div>
                                </div>

                            </div>
                            <div class="inner-title mt-25">
                                <h2><?php echo e(__('Facilities')); ?></h2>
                                <div class="sec-line mb-15"></div>
                                <ul>
                                    <?php $__currentLoopData = getFacilities($hotel->facilities); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $facility): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($facility); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>

                            <div class="inner-title mt-25" id="accommodation_section">
                                <h2><?php echo e(__('Accommodation')); ?></h2>
                                <div class="sec-line mb-15"></div>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th><?php echo e(__('Room Type')); ?></th>
                                            <th width="10%"><?php echo e(__('Sleeps')); ?></th>
                                            <th width="12%"><?php echo e(__('Today\'s Price')); ?></th>
                                            <th width="15%"><?php echo e(__('Booking')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $hotel_accommodations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hotel_accommodation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <h3 class="mb-0">
                                                        <a href="#hotel_images_modal" data-toggle="modal"
                                                            data-url="<?php echo e(route('hotel-accommodation-image', $hotel_accommodation->id)); ?>"
                                                            data
                                                            class="accommodation_images"><?php echo e($hotel_accommodation->accommodation->name); ?></a>
                                                    </h3>
                                                    <?php
                                                        $h_a_facilities = getFacilities($hotel_accommodation->facilities);
                                                    ?>
                                                    <h6 class="mb-0"><?php echo e(__('Facilities:')); ?></h6>
                                                    <ul>
                                                        <?php $__currentLoopData = $h_a_facilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $h_a_facility): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li class="singleFacility">
                                                                <?php echo e($h_a_facility); ?></li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </td>
                                                <td>
                                                    <?php echo e($hotel_accommodation->no_of_adult . __(' Adult')); ?> <br />
                                                    <?php echo e($hotel_accommodation->no_of_children . __(' Children')); ?>

                                                </td>
                                                <td class="text-center"><?php echo e(discountPriceCalculate($hotel_accommodation->price, $discount)['price']); ?>

                                                </td>
                                                <td>
                                                    <a class="btn-theme"
                                                        href="<?php echo e(route('booking.hotel', ['hotel_id' => $hotel->id, 'accommodation_id' => $hotel_accommodation->id])); ?>"><?php echo e(__('Booking Now')); ?></a>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Special Packages Section End -->


    <?php if($page_client_say): ?>
        <!-- Testimonials Section Start -->
        <section class="testimonials-section pt-80 pb-80">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="inner-title mt-25">
                            <h2><?php echo e(clean($page_client_say ? $page_client_say->title : '')); ?></h2>
                            <div class="sec-line mb-40"></div>
                        </div>
                        <div class="testimonials-post testimonials_slide owl-carousel owl-theme owl-navst st-three">
                            <?php $__currentLoopData = $page_client_say_testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="testimonials-item">
                                    <div class="thumb">
                                        <?php echo imageShow($testimonial->image, 'Client Photo'); ?>

                                    </div>
                                    <div class="content">
                                        <h5><?php echo e(clean($testimonial ? $testimonial->name : '')); ?> <small>-
                                                <?php echo e(clean($testimonial ? $testimonial->designation : '')); ?></small></h5>
                                        <?php echo ratingShow($testimonial->rating); ?>

                                        <p><i class="fa fa-quote-left"></i>
                                            <?php echo e(clean($testimonial ? $testimonial->testimonial : '')); ?>

                                        </p>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Testimonials Section End -->
    <?php endif; ?>



    <div class="modal fade" id="hotel_images_modal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="hotel_images_modal_title"></h5>
                    <button type="button" class="btn btn-close" data-dismiss="modal" aria-label="Close"><i
                            class="fa fa-times"></i></button>
                </div>
                <div class="modal-body" id="hotel_images">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->make('frontend.pages.hotel.map-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <?php echo $__env->make('frontend.scripts.gallery-js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('frontend.scripts.map-script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('frontend.pages.hotel.image-script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/frontend/pages/hotel/singleHotel.blade.php ENDPATH**/ ?>