

<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>

<?php $__env->startSection('page-css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/images-grid.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/daterangepicker.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" data-background="<?php echo e(asset('frontend/images/bg/px-1.jpg')); ?>" data-type="parallax"
        data-speed="3">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(isset($title) ? clean($title) : ''); ?></h4>
                        <p><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Home')); ?></a>
                            <a><?php echo e(isset($title) ? clean($title) : ''); ?></a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->
    <!-- Contact Section Start -->
    <div class="container mt-3">
        <?php if(Session::get('message')): ?>
            <div class="alert alert-success"><?php echo e(Session::get('message')); ?></div>
        <?php endif; ?>
    </div>
    <section class="contact-section pt-5 pb-20">
        <div class="container">
            <div class="row contact-bg">
                <div class="col-md-12 col-lg-4 p-0">
                    <div class="contact-text">
                        <h2><?php echo e(__('We are')); ?> <span><?php echo e(__('Booking')); ?></span></h2>
                        <h4><?php echo e(clean($accommodation->hotel->hotel_name)); ?></h4>
                        <div class="sec-line mb-20"></div>
                        <div class="contact-info">
                            <div class="icon-box">
                                <i class="flaticon-pin-1"></i>
                            </div>
                            <h6><?php echo e(__('Country: ')); ?> <?php echo e(clean($accommodation->hotel->hotelCountry->name . ', ')); ?></h6>
                            <h6><?php echo e(__('City: ')); ?> <?php echo e(clean($accommodation->hotel->hotelCity->name . ', ')); ?></h6>
                        </div>
                        <div class="contact-info">
                            <div class="icon-box">
                                <i class="flaticon-flash"></i>
                            </div>
                            <h6><?php echo e(clean($accommodation->hotel->phone . ', ')); ?></h6>
                        </div>
                        <div class="contact-info">
                            <div class="icon-box">
                                <i class="pe-7s-map"></i>
                            </div>
                            <h6><a
                                    href="mailto:<?php echo e($accommodation->hotel->email); ?>"><?php echo e(clean($accommodation->hotel->email . ', ')); ?></a>
                            </h6>
                        </div>
                        <?php if($accommodation->hotel && $accommodation->hotel->website): ?>
                            <div class="contact-info">
                                <div class="icon-box">
                                    <i class="pe-7s-server"></i>
                                </div>
                                <h6><a
                                        href="<?php echo e($accommodation->hotel->website); ?>"><?php echo e(clean($accommodation->hotel->website)); ?></a>
                                </h6>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-md-12 col-lg-8 style-2">
                    <form class="booking-form" method="post" action="<?php echo e(route('booking.hotel.save')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="form-row">
                            <div class="form-group col-md-12 mb-1">
                                <label for=""><?php echo e(__('Accommodation')); ?></label>
                                <select name="hotel_accommodation_id" class="form-control mb-0">
                                    <?php $__currentLoopData = $hotel_accommodations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hotel_accommodation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e($hotel_accommodation->id == $accommodation->id ? 'selected' : ''); ?>

                                            value="<?php echo e($hotel_accommodation->id); ?>">
                                            <?php echo e($hotel_accommodation->accommodation->name . ' (' . discountPriceCalculate($hotel_accommodation->price, $discount)['price'] . ') (' . $hotel_accommodation->no_of_guest . __('Person') . ')'); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['hotel_accommodation_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group col-md-7 mb-1">
                                <label for=""><?php echo e(__('Check In out')); ?></label>
                                <input type="text" id="datetimepicker" name="check_in_out" class="form-control" />
                                <?php $__errorArgs = ['check_in_out'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group col-md-5 mb-1">
                                <label for=""><?php echo e(__('Arrival Time')); ?></label>
                                <input type="text" id="arrival_date_time" name="arrival_date_time" class="form-control" />
                                <?php $__errorArgs = ['arrival_date_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group col-md-6 mb-1">
                                <label for=""><?php echo e(__('First Name')); ?></label>
                                <input type="text" name="first_name" value="<?php echo e(Auth::user()->name); ?>" class="form-control mb-1"
                                    value="<?php echo e(old('first_name')); ?>" />
                                <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group col-md-6 mb-1">
                                <label for=""><?php echo e(__('Last Name')); ?></label>
                                <input type="text" name="last_name" value="<?php echo e(Auth::user()->surname); ?>" class="form-control mb-1"
                                    value="<?php echo e(old('last_name')); ?>" />
                                <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group col-md-6 mb-4">
                                <label for=""><?php echo e(__('Email')); ?></label>
                                <input type="email" name="email" value="<?php echo e(Auth::user()->email); ?>" class="form-control mb-0" placeholder="Email"
                                    value="<?php echo e(old('email')); ?>" />
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <small class="text-mute"><?php echo e(__('Confirmation email sent to this address')); ?></small>
                            </div>
                            <div class="form-group col-md-6 mb-4">
                                <label for=""><?php echo e(__('Are you traveling for work?')); ?></label>
                                <div class="clearfix"></div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" id="is_travel_for_work_yes"
                                        name="is_travel_for_work" value="<?php echo e(ACTIVE_STATUS); ?>">
                                    <label class="form-check-label" for="is_travel_for_work_yes">
                                        <?php echo e(__('Yes')); ?></label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" id="is_travel_for_work_no"
                                        name="is_travel_for_work" value="<?php echo e(DEACTIVE_STATUS); ?>" checked>
                                    <label class="form-check-label" for="is_travel_for_work_no">
                                        <?php echo e(__('No')); ?></label>
                                </div>
                            </div>

                            <div class="form-group col-md-12">
                                <div class="contact-textarea text-center">
                                    <button class="btn btn-theme" type="submit"
                                        value="Submit Form"><?php echo e(__('Reserve')); ?></button>
                                </div>
                                <input type="hidden" name="hotel_id" value="<?php echo e(clean($accommodation->hotel_id)); ?>">
                                <input type="hidden" name="discount_id" value="<?php echo e(clean((($discount) ? $discount->id : ''))); ?>">
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </section>
    <!-- Contact Section End -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <script type="text/javascript" src="<?php echo e(asset('js/moment.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/daterangepicker.js')); ?>"></script>
    <?php echo $__env->make('frontend.pages.booking.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/frontend/pages/booking/hotel.blade.php ENDPATH**/ ?>