
<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>
<?php $__env->startSection('page-css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-light bg-dark text-center">
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a>
                    <span class="breadcrumb-item active"><?php echo e(__($title)); ?></span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header">
                        <h6 class="card-title"><?php echo e(__($title)); ?></h6>
                    </div>
                    <form action="<?php echo e(route('admin.payment.update', $payment->id)); ?>" method="POST"
                          enctype="multipart/form-data">
                        <div class="card-body">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <p class="mb-1"><?php echo e(__('Name')); ?>: </p>
                                <div class="input-group input-group-lg">
                                    <input type="text" name="name" class="form-control" aria-label="Large"
                                           aria-describedby="inputGroup-sizing-sm" placeholder="<?php echo e(__('Name')); ?>"
                                           value="<?php echo e($payment ? ucfirst($payment->name) : ''); ?>">
                                </div>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <?php if($payment->method_type == PAYPAL_PAYMENT): ?>
                                <div class="mb-3">
                                    <p class="mb-1"><?php echo e(__('Account No')); ?>: </p>
                                    <div class="input-group input-group-lg">
                                        <input type="text" name="account" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm" placeholder="<?php echo e(__('Account No')); ?>"
                                               value="<?php echo e($payment ? $payment->account : ''); ?>">
                                    </div>
                                    <?php $__errorArgs = ['account'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <p class="mb-1"><?php echo e(__('Client ID')); ?>: </p>
                                    <div class="input-group input-group-lg">
                                        <input type="text" name="client_id" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm" placeholder="<?php echo e(__('Client ID')); ?>"
                                               value="<?php echo e($payment ? $payment->client_id : ''); ?>">
                                    </div>
                                    <?php $__errorArgs = ['client_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            <?php elseif($payment->method_type == STRIPE_PAYMENT): ?>
                                <div class="mb-3">
                                    <p class="mb-1"><?php echo e(__('API ID')); ?>: </p>
                                    <div class="input-group input-group-lg">
                                        <input type="text" name="api_id" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm" placeholder="<?php echo e(__('Api ID')); ?>"
                                               value="<?php echo e($payment ? $payment->api_id : ''); ?>">
                                    </div>
                                    <?php $__errorArgs = ['api_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            <?php endif; ?>

                            <div class="mb-3">
                                <p class="mb-1"><?php echo e(__('Secret ID')); ?>: </p>
                                <div class="input-group input-group-lg">
                                    <input type="text" name="secret_key" class="form-control" aria-label="Large"
                                           aria-describedby="inputGroup-sizing-sm" placeholder="<?php echo e(__('Secret ID')); ?>"
                                           value="<?php echo e($payment ? $payment->secret_key : ''); ?>">
                                </div>
                                <?php $__errorArgs = ['secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="mb-3">
                                <p class="h6 mb-3">
                                    <?php echo e(__('Logo')); ?>:<code><?php echo e(__('(Only jpeg, png, jpg and gif file is acceptable)')); ?></code>
                                </p>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <div class="">
                                            <div class="logo-image" id="feature_image">
                                                <div class="input-images"></div>
                                                <input type="file" name="logo" class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 text-center">
                                        <?php if($payment): ?>
                                            <img src="<?php echo e($payment->logo); ?>" class="img-thumbnail" width="35%" alt="<?php echo e(__('Logo')); ?>">
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="card-footer">
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                        type="submit"><?php echo e(__('Submit form')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <?php echo $__env->make('backend.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script src="<?php echo e(asset('backend/assets/js/payment-method.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/payment/from.blade.php ENDPATH**/ ?>