
<?php $__env->startSection('title', config('app.name', 'laravel').' | '.$title); ?>
<?php $__env->startSection('page-css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div id="wrapper-content">
    <div class="row">
        <div class="col">
            <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a>
                <span class="breadcrumb-item active"><?php echo e(__($title)); ?></span>
                <span class="breadcrumb-info" id="time"></span>
            </nav>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card card-dark bg-dark">
                <div class="card-header">
                    <h6 class="card-title"><?php echo e(__($title)); ?></h6>
                </div>
                <form action="<?php echo e(route('admin.settings.general-save')); ?>" method="POST" enctype="multipart/form-data">
                    <div class="card-body">
                        <?php echo csrf_field(); ?>
                        <!-- Site Name -->
                        <div class="mb-3">
                            <p class="mb-1"><?php echo e(__('Site Name')); ?>: </p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="site_name" class="form-control" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="<?php echo e(__('Site Name')); ?>" value="<?php echo e($generalSetting?clean($generalSetting->site_name):''); ?>">
                            </div>
                            <?php if($errors->has('site_name')): ?>
                                <span class="text-danger"><?php echo e($errors->first('site_name')); ?></span>
                            <?php endif; ?>
                        </div>

                        <!-- Site Tag Line -->
                        <div class="mb-3">
                            <p class="mb-1"><?php echo e(__('Site Tag Line')); ?>: </p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="site_tag_line" class="form-control" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="<?php echo e(__('Site Tag Line')); ?>" value="<?php echo e($generalSetting?clean($generalSetting->site_tag_line):''); ?>">
                            </div>
                            <?php if($errors->has('site_tag_line')): ?>
                                <span class="text-danger"><?php echo e($errors->first('site_tag_line')); ?></span>
                            <?php endif; ?>
                        </div>

                        <!-- Site Sub Tag Line -->
                        <div class="mb-3">
                            <p class="mb-1"><?php echo e(__('Site Sub Tag Line')); ?>: </p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="site_sub_tag_line" class="form-control" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="<?php echo e(__('Site Sub Tag Line')); ?>" value="<?php echo e($generalSetting?clean($generalSetting->site_sub_tag_line):''); ?>">
                            </div>
                            <?php if($errors->has('site_sub_tag_line')): ?>
                                <span class="text-danger"><?php echo e($errors->first('site_sub_tag_line')); ?></span>
                            <?php endif; ?>
                        </div>

                        <!-- Author Name -->
                        <div class="mb-3">
                            <p class="mb-1"><?php echo e(__('Author Name')); ?>: </p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="author_name" class="form-control" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="<?php echo e(__('Author Name')); ?>" value="<?php echo e($generalSetting?clean($generalSetting->author_name):''); ?>">
                            </div>
                            <?php if($errors->has('author_name')): ?>
                                <span class="text-danger"><?php echo e($errors->first('author_name')); ?></span>
                            <?php endif; ?>
                        </div>

                        <!-- Og Meta Title -->
                        <div class="mb-3">
                            <p class="mb-1"><?php echo e(__('Og Meta Title')); ?>: </p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="og_meta_title" class="form-control" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="<?php echo e(__('Og Meta Title')); ?>" value="<?php echo e($generalSetting?clean($generalSetting->og_meta_title):''); ?>">
                            </div>
                            <?php if($errors->has('og_meta_title')): ?>
                                <span class="text-danger"><?php echo e($errors->first('og_meta_title')); ?></span>
                            <?php endif; ?>
                        </div>

                        <!-- Og Meta Description -->
                        <div class="mb-3">
                            <p class="mb-1"><?php echo e(__('Og Meta Description')); ?>: <code><?php echo e(__('maximum 50 word')); ?></code></p>
                            <div class="input-group input-group-lg">
                <textarea class="form-control" name="og_meta_description" aria-label="With textarea"
                          rows="4"><?php echo e($generalSetting?clean($generalSetting->og_meta_description):''); ?></textarea>
                            </div>
                            <?php if($errors->has('og_meta_description')): ?>
                                <span class="text-danger"><?php echo e($errors->first('og_meta_description')); ?></span>
                            <?php endif; ?>
                        </div>

                        <!-- Currency Symbol -->
                        <div class="mb-3">
                            <p class="mb-1"><?php echo e(__('Currency Symbol')); ?>:</p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="currency_symbol" class="form-control" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="<?php echo e(__('Currency Symbol')); ?>" value="<?php echo e($generalSetting?clean($generalSetting->currency_symbol):''); ?>">
                            </div>
                            <?php if($errors->has('currency_symbol')): ?>
                                <span class="text-danger"><?php echo e($errors->first('currency_symbol')); ?></span>
                            <?php endif; ?>
                        </div>

                        <!-- Google Map Api Key -->
                        <div class="mb-3">
                            <p class="mb-1"><?php echo e(__('Google Map Api Key')); ?>:</p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="google_map_api_key" class="form-control" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="<?php echo e(__('Api Key')); ?>" value="<?php echo e($generalSetting?clean($generalSetting->google_map_api_key):''); ?>">
                            </div>
                            <?php if($errors->has('google_map_api_key')): ?>
                                <span class="text-danger"><?php echo e($errors->first('google_map_api_key')); ?></span>
                            <?php endif; ?>
                        </div>

                        <!-- Og Meta Image -->
                        <div class="mb-3">
                            <p class="mb-1"><?php echo e(__('Og Meta Image')); ?>: <code><?php echo e(__('expected size is 32x32px')); ?></code></p>
                            <div class="form-row">
                                <div class="col-md-10 col-sm-12">
                                    <div class="form-group">
                                        <div role="button" class="btn btn-primary mr-2">
                                            <input type="file" title='Click to add Files' name="og_meta_image" />
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2 d-md-block d-sm-none">
                                    <div class="img-favicon">
                                        <?php if($generalSetting): ?>
                                            <?php echo imageShow($generalSetting->og_meta_image, 'Og Meta Image', 'img-thumbnail', '', 'App\Models\GeneralSettings', $generalSetting->id, 'og_meta_image'); ?>

                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php if($errors->has('og_meta_image')): ?>
                                <span class="text-danger"><?php echo e($errors->first('og_meta_image')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Form Submit -->
                    <div class="card-footer">
                        <div class="wizard-action text-left">
                            <button class="btn btn-wave-light btn-danger btn-lg" type="submit"><?php echo e(__('Submit form')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <?php echo $__env->make('backend.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.pages.delete-warning', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/settings/general.blade.php ENDPATH**/ ?>