

<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>

<?php $__env->startSection('page-css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('frontend/nouislider/dist/nouislider.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" style="<?php if(!empty($page_header->bg_img)): ?>background-image: url(<?php echo e($page_header->bg_img); ?>);<?php else: ?> background-image: url(<?php echo e(asset('frontend/images/bg/px-1.jpg')); ?>); <?php endif; ?>" data-type="parallax" data-speed="3">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(isset($title) ? clean($title) : ''); ?></h4>
                        <p><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Home')); ?></a>
                            <a><?php echo e(isset($title) ? clean($title) : ''); ?></a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    <!-- Special Packages Section Start -->
    <section class="special-packages-sec pt-4 pb-60">
        <div class="container">
            <div class="list-size">
                <div class="row">
                    <div class="col-sm-3">
                        <div class="card mb-4">
                            <div class="card-body">
                                <form id="data_form" method="GET">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="page" id="page" value="1">
                                    <div class="form-group">
                                        <label for=""><?php echo e(__('Place')); ?></label>
                                        <select name="place_id" class="form-control">
                                            <option value=""><?php echo e(__('Select')); ?></option>
                                            <?php $__currentLoopData = $places; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $place): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php echo e((!empty($place_id) && $place_id == $place->id) ? 'selected' : ''); ?> value="<?php echo e($place->id); ?>"><?php echo e($place->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for=""><?php echo e(__('Category')); ?></label>
                                        <select name="category_id" class="form-control">
                                            <option value=""><?php echo e(__('Select')); ?></option>
                                            <?php $__currentLoopData = $package_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php echo e((!empty($category_id) && $category_id == $package_category->id) ? 'selected' : ''); ?> value="<?php echo e($package_category->id); ?>"><?php echo e($package_category->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for=""><?php echo e(__('Price')); ?></label>
                                        <div id="steps-slider" class="mt-1"></div>
                                        <input type="hidden" id="min_price" name="min_price" value="<?php echo e($min_price); ?>" />
                                        <input type="hidden" id="max_price" name="max_price" value="<?php echo e($max_price); ?>" />
                                        <div class="d-flex justify-content-between mt-1">
                                            <span id="min_price_show"></span>
                                            <span id="max_price_show"></span>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-9" id="data_html">
                        <?php echo $list_view; ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Special Packages Section End -->

    <?php if($left_package || $right_package_img): ?>
        <!-- Global Section Start -->
        <section class="global-section over-layer-white pt-80 pb-70">
            <div class="container">
                <div class="row">
                    <?php if($left_package): ?>
                        <div class="col-xl-7 col-lg-12">
                            <div class="global-area">
                                <div class="inner-title">
                                    <h2><?php echo e(clean($left_package ? $left_package->title : '')); ?></h2>
                                    <h3><?php echo e(clean($left_package ? $left_package->sub_title : '')); ?></h3>
                                    <div class="sec-line"></div>
                                </div>
                                <?php echo clean($left_package ? $left_package->description : ''); ?>

                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($right_package_img): ?>
                        <div class="col-xl-5 col-lg-8 col-md-10">
                            <?php if($right_package_img && $right_package_img->fnt_img): ?>
                                <div class="map-area">
                                    <?php echo imageShow($right_package_img->fnt_img, __('Image')); ?>

                                </div>
                            <?php endif; ?>
                            <p class="map-content">
                                <?php echo e(clean($right_package_img ? $right_package_img->about_image_phone : '')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
        <!-- Global Section End -->
    <?php endif; ?>

    <?php if($testimonial_setting): ?>
        <!-- Testimonials Section Start -->
        <section class="testimonials-section pt-80 pb-80">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="inner-title mt-25">
                            <h2><?php echo e(clean($testimonial_setting ? $testimonial_setting->title : '')); ?></h2>
                            <div class="sec-line mb-40"></div>
                        </div>
                        <div class="testimonials-post testimonials_slide owl-carousel owl-theme owl-navst st-three">
                            <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="testimonials-item">
                                    <div class="thumb">
                                        <?php echo imageShow($testimonial->image, __('Testimonial')); ?>

                                    </div>
                                    <div class="content">
                                        <h5><?php echo e(clean($testimonial ? $testimonial->name : '')); ?> <small>-
                                                <?php echo e(clean($testimonial ? $testimonial->designation : '')); ?></small></h5>
                                        <?php echo ratingShow($testimonial->rating); ?>

                                        <p><i class="fa fa-quote-left"></i>
                                            <?php echo e(clean($testimonial ? $testimonial->testimonial : '')); ?>

                                        </p>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Testimonials Section End -->
    <?php endif; ?>

    <?php echo $__env->make('frontend.pages.packages.map-image-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <?php echo $__env->make('frontend.pages.packages.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('frontend.scripts.package-map-script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/frontend/pages/packages/index.blade.php ENDPATH**/ ?>