

<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>

<?php $__env->startSection('page-css'); ?>
    <link href="<?php echo e(asset('backend/assets/plugin/select2/select2.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a>
                    <span class="breadcrumb-item active"><?php echo e($title); ?></span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">

                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <h6 class="card-title lh-35"><?php echo e($title); ?></h6>
                            </div>
                        </div>
                    </div>

                    <div class="card-body p-0">
                        <form
                            action="<?php echo e($blog ? route('admin.blog.weblog.update', $blog->id) : route('admin.blog.weblog.store')); ?>"
                            method="POST" enctype="multipart/form-data" class="wma-form">
                            <?php echo csrf_field(); ?>
                            <?php if($blog): ?>
                                <?php echo method_field('PUT'); ?>
                            <?php endif; ?>


                            <p class="mb-1"><label for="name"
                                    class="card-title font-weight-bold"><?php echo e(__('Title :')); ?></label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" name="title" value="<?php echo e(__($blog ? $blog->title : old('title'))); ?>"
                                    class="form-control" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                    placeholder="<?php echo e(__('Title')); ?>" required>
                            </div>


                            <p class="mb-1"><label for="name"
                                    class="card-title font-weight-bold"><?php echo e(__('Category:')); ?></label></p>
                            <div class="input-group input-group-lg mb-3">
                                <select class="form-control form-control-lg" name="category_id">
                                    <option value=""><?php echo e(__('Select one')); ?></option>

                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"
                                            <?php echo e($blog ? ($blog->category_id == $category->id ? 'selected' : '') : ''); ?>>
                                            <?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                                <br>
                            </div>

                            <p class="h6 mb-3">
                                <?php echo e(__('Background Image')); ?>:<code><?php echo e(__('(Only jpeg, png, jpg and gif file is
                                acceptable)')); ?></code>
                            </p>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <div class="">
                                        <div class="thumbnail-image" id="thumbnail_image">
                                            <div class="input-images"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 text-center">
                                    <?php if($blog): ?>
                                        <?php echo imageShow($blog->bg_image, '', 'img-thumbnail', 'width="35%" height="200"', 'App\Models\Blog', $blog->id, 'bg_image'); ?>

                                    <?php endif; ?>
                                </div>
                            </div>

                            <p class="h6 mb-3">
                                <?php echo e(__('Feature Image')); ?>:<code><?php echo e(__('(Only jpeg, png, jpg and gif file is
                                acceptable)')); ?></code>
                            </p>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <div class="">
                                        <div class="feature-image" id="feature_image">
                                            <div class="input-images"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 text-center">
                                    <?php if($blog): ?>
                                        <?php echo imageShow($blog->feature_img, 'Feature image', 'img-thumbnail', 'width="35%"', 'App\Models\Blog', $blog->id, 'feature_img'); ?>

                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="pageContent">
                                    <span class="d-block card-title mb-1 font-weight-bold"><?php echo e(__('Description')); ?> </span>
                                </label>
                                <textarea name="description" id="description" rows="10" class="form-control bapric_edittor"
                                    placeholder="<?php echo e(__('Blog description here')); ?>"><?php echo clean($blog ? $blog->description : old('description')); ?></textarea>
                            </div>

                            <p class="mb-1"><label for="name"
                                    class="card-title font-weight-bold"><?php echo e(__('Tags :')); ?></label></p>
                            <div class="input-group input-group-lg mb-3">
                                <select class="form-control form-control-lg blog_tag_multiple_input" name="blog_tags[]"
                                    multiple="multiple">
                                    <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($tag->id); ?>"
                                            <?php echo e(in_array($tag->id, $blog_tags) ? 'selected' : ''); ?>><?php echo e($tag->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                                <br>
                            </div>
                            <input type="hidden" name="user_id" value="<?php echo e(Auth::user()->id); ?>">
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                    type="submit"><?php echo e(__('Submit')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <script src="<?php echo e(asset('backend/assets/plugin/select2/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/blog.js')); ?>"></script>
    <?php echo $__env->make('backend.pages.delete-warning', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/blogs/blog-form.blade.php ENDPATH**/ ?>