
<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>
<?php $__env->startSection('page-css'); ?>
    <link href="<?php echo e(asset('backend/assets/plugin/select2/select2.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a>
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.hotel.index')); ?>"><?php echo e(__('Hotel')); ?></a>
                    <span class="breadcrumb-item active"><?php echo e(__($title)); ?></span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header">
                        <h6 class="card-title"><?php echo e(__($title)); ?></h6>
                    </div>
                    <form action="<?php echo e($item ? route('admin.facility.update', $item->id) : route('admin.facility.store')); ?>"
                        method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php if($item): ?>
                            <?php echo method_field('PATCH'); ?>
                        <?php endif; ?>
                        <div class="card-body ">
                            <div class="form-row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for=""><?php echo e(__('Title')); ?></label>
                                        <input type="text" name="name" value="<?php echo e($item ? $item->name : old('name')); ?>" class="form-control">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <p class="mb-2 font-weight-bold"><?php echo e(__('Main Image :')); ?>

                                            <code><?php echo e(__('(Only jpeg, png, jpg and gif file is acceptable)')); ?></code>
                                        </p>
                                        <div class="mb-3">
                                            <div class="facility_icon" id="facility_icon">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        <?php $__errorArgs = ['icon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <?php if($item): ?>
                                        <div class="pl-3 pr-2 ">
                                            <p class="mb-2 font-weight-bold "><?php echo e(__('Facility Icon :')); ?> </p>
                                            <?php echo imageShow($item->icon, 'Facility Icon', 'img-thumbnail bg-secondary', 'width="200" height="100"', 'App\Models\Facility', $item->id, 'icon'); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="col-sm-4">
                                    <p class="mb-2 font-weight-bold "><?php echo e(__('Status')); ?> </p>
                                    <label class="switch">
                                        <input type="checkbox" name="status"
                                            <?php echo e($item && $item->parking_info == ACTIVE_STATUS ? 'checked' : ''); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>

                            </div>
                        </div>
                        <div class="card-footer text-right">
                            <div class="wizard-action">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                    type="submit"><?php echo e(__('Submit & Next')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    <?php echo $__env->make('backend.pages.hotel.facility.internal-scripts.page-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.pages.delete-warning', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('backend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/hotel/facility/form.blade.php ENDPATH**/ ?>