
<?php $__env->startSection('title', config('app.name', 'laravel').' | '.$title); ?>
<?php $__env->startSection('page-css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a>
                    <a class="breadcrumb-item text-white"
                       href="<?php echo e(route('admin.gallery.index')); ?>"><?php echo e(__('Gallery')); ?></a>
                    <span class="breadcrumb-item active"><?php echo e(__($title)); ?></span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header">
                        <h6 class="card-title"><?php echo e(__($title)); ?></h6>
                    </div>
                    <form
                        action="<?php echo e($gallery? route('admin.gallery.update',$gallery->id) : route('admin.gallery.store')); ?>"
                        method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php if($gallery): ?>
                            <?php echo method_field('PATCH'); ?>
                        <?php endif; ?>
                        <div class="card-body ">
                            <div class="form-row">
                                <div class="col-md-6 pr-2">
                                    <p class="mb-1 font-weight-bold"><?php echo e(__('Title :')); ?> </p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="text" name="title" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm"
                                               placeholder="<?php echo e(__('Image name')); ?>"
                                               value="<?php echo e($gallery?$gallery->title:old('title')); ?>">
                                        <br>
                                        <?php if($errors->has('title')): ?>
                                            <span class="text-danger"><?php echo e($errors->first('title')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-6 pl-3">
                                    <div class=" ">
                                        <p class="mb-2 font-weight-bold"><?php echo e(__('Image : ')); ?>

                                            <code><?php echo e(('Acceptable image size 370 x 336 pixel')); ?></code></p>
                                        <div class="mb-3">
                                            <div class="partner_bg_image" id="partner_bg_image">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if($gallery): ?>
                                        <div class="pr-2 ">
                                            <p class="mb-2 font-weight-bold "><?php echo e(__('Old Image :')); ?> </p>
                                            <?php echo imageShow($gallery->image, 'Image', 'img-thumbnail bg-secondary', 'width="200"', 'App\Models\Gallery', $gallery->id, 'image'); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                        type="submit"><?php echo e(__('Submit form')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    <?php echo $__env->make('backend.pages.gallery.internal-assets.js.gallery-page-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.pages.delete-warning', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/gallery/form.blade.php ENDPATH**/ ?>