<script src="<?php echo e(asset('frontend/nouislider/dist/nouislider.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/nouislider/dist/wNumb.js')); ?>"></script>
<script>
    (function($) {
        "use strict";
        // Author code here
        $(document.body).on('change', '#data_form select', function() {
            $('#page').val(1);
            packageList();
        });

        $(document.body).on('change', '#price_range', function() {
            $('#page').val(1);
            var price = $(this).val();
            $('#price_max').text(price);
            packageList();
        });

        $(document.body).on('click', '.page-link-item li a', function(event) {
            event.preventDefault();
            var page = $(this).data('page');

            if (typeof page != 'undefined') {
                $('#page').val(page);
                packageList();
            }
        });

        var stepsSlider = document.getElementById('steps-slider');
        var input0 = document.getElementById('min_price');
        var input1 = document.getElementById('max_price');
        var inputs = [input0, input1];

        var min_request_price = <?php echo e($min_price > 0 ? $min_price-1 : $list_min_price); ?>;
        var max_request_price = <?php echo e($max_price > 0 ? $max_price : $list_max_price); ?>;

        input0.value = min_request_price;
        input1.value = max_request_price;

        noUiSlider.create(stepsSlider, {
            start: [min_request_price, max_request_price],
            connect: true,
            tooltips: [true, wNumb({decimals: 1})],
            step: 10,
            range: {
                'min': <?php echo e($list_min_price); ?>,
                'max': <?php echo e($list_max_price); ?>

            }
        });

        stepsSlider.noUiSlider.on('change', function (values, handle) {
            inputs[handle].value = values[handle];
            packageList();
        });

        function packageList() {
            var form_data = $('#data_form').serialize();
            var form_url = "<?php echo e(route('package')); ?>";

            $('#data_html').prepend(
                '<div id="loading_overlay" class="text-center pt-100"><i class="fa fa-spinner fa-pulse fa-4x fa-fw mr-1"></i><br /><?php echo e(__('Loading')); ?></div>'
            );
            $.ajax({
                type: 'get',
                url: form_url,
                data: form_data,
                headers: {
                    'Content-Type':'application/json'
                },
                success: function(data) {
                    $('#data_html').html(data.list_view);
                    let page = data.page;
                    $('#page').val(page);

                    const url = form_url + '?' + form_data;
                    history.pushState('', 'Package List', url);
                }
            })
        }

    })(jQuery);
</script><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/frontend/pages/packages/script.blade.php ENDPATH**/ ?>