
<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>
<?php $__env->startSection('page-css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a>
                    <span class="breadcrumb-item active"><?php echo e(__($title)); ?></span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <h6 class="card-title lh-35"><?php echo e(__($title)); ?></h6>
                            </div>
                            <div class="col-md-6 col-sm-12 text-right">
                                <button type="button" class="addBlogCategoryBtn btn btn-danger btn-sm rounded"><i
                                        class="material-icons"><?php echo e(__('add')); ?></i></button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example" class="table bapric_table table-striped table-bordered miw-500 data-table"
                                cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th width="10%"><?php echo e(__('SL')); ?></th>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th width="10%"><?php echo e(__('Status')); ?></th>
                                        <th width="10%"><?php echo e(__('Action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Blog Category Modal -->
        <div class="modal fade" id="blogCategoryModal" tabindex="-1" role="dialog"
            aria-labelledby="blogCategoryModalTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title card-title" id="blogCategoryModalLongTitle">
                            <?php echo e(__('Add new accommodation')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="<?php echo e(route('admin.accommodation.store')); ?>" method="post" id="blogCategoryForm">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <p class="card-title"><label for="name"><?php echo e(__('Accommodation Name')); ?></label></p>
                            <div class="form-group">
                                <input type="text" name="name" id="name" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <p class="card-title"><?php echo e(__('Status')); ?></p>
                                <label class="switch">
                                    <input type="checkbox" checked name="status">
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary"
                                data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                            <button type="submit" class="btn btn-danger"><?php echo e(__('Save')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    <?php echo $__env->make('backend.pages.blogs.internal-assets.js.delete-warning', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.pages.hotel.accommodation.internal-assets.datatable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script src="<?php echo e(asset('backend/assets/js/edit-modal.js')); ?>"></script>
    <?php echo $__env->make('backend.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/hotel/accommodation/index.blade.php ENDPATH**/ ?>