
<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>
<?php $__env->startSection('page-css'); ?>
    <link href="<?php echo e(asset('backend/assets/plugin/select2/select2.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a>
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.hotel.index')); ?>"><?php echo e(__('Hotel')); ?></a>
                    <span class="breadcrumb-item active"><?php echo e(__($title)); ?></span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header">
                        <h6 class="card-title"><?php echo e(__($title)); ?></h6>
                    </div>
                    <form action="<?php echo e($hotel ? route('admin.hotel.update', $hotel->id) : route('admin.hotel.store')); ?>"
                        method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php if($hotel): ?>
                            <?php echo method_field('PATCH'); ?>
                        <?php endif; ?>
                        <div class="card-body ">
                            <div class="form-row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Country Name :')); ?> </p>
                                        <select class="form-control single_select" name="country" id="country_select">
                                            <option value=""><?php echo e(__('Select')); ?></option>
                                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option
                                                    <?php echo e($hotel && $hotel->country == $id->id ? 'selected' : ''); ?>

                                                    value="<?php echo e($id->id); ?>"><?php echo e($id->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('City Name :')); ?> </p>
                                        <select class="w-100 form-control single_select" name="city" id="cities_id">
                                            <option value=""><?php echo e(__('Select one')); ?></option>
                                            <?php if(isset($hotel) && count($cities)): ?>
                                                <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php echo e($hotel->city == $city->id ? 'selected' : ''); ?>

                                                        value="<?php echo e($city->id); ?>"><?php echo e($city->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Hotel Address :')); ?> </p>
                                        <input type="text" name="hotel_location" class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm"
                                            placeholder="<?php echo e(__('Hotel Location')); ?>"
                                            value="<?php echo e($hotel ? $hotel->hotel_location : old('hotel_location')); ?>">
                                        <?php $__errorArgs = ['hotel_location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Latitude :')); ?> </p>
                                        <input type="number" min="-90" max="90" step="any" name="latitude"
                                            class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm"
                                            placeholder="<?php echo e(__('Hotel Location')); ?>"
                                            value="<?php echo e($hotel ? $hotel->latitude : old('latitude')); ?>">

                                        <?php $__errorArgs = ['latitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Longitude :')); ?> </p>
                                        <input type="number" min="-180" max="180" step="any" name="longitude"
                                            class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm"
                                            placeholder="<?php echo e(__('Hotel Location')); ?>"
                                            value="<?php echo e($hotel ? $hotel->longitude : old('longitude')); ?>">

                                        <?php $__errorArgs = ['longitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Hotel Name :')); ?> </p>
                                        <input type="text" name="hotel_name" class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="<?php echo e(__('Hotel Name')); ?>"
                                            value="<?php echo e($hotel ? $hotel->hotel_name : old('hotel_name')); ?>">
                                        <?php $__errorArgs = ['hotel_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Email :')); ?> </p>
                                        <input type="email" name="email" class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="<?php echo e(__('Hotel Email')); ?>"
                                            value="<?php echo e($hotel ? $hotel->email : old('email')); ?>">
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Phone :')); ?> </p>
                                        <input type="tel" name="phone" class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="<?php echo e(__('Phone')); ?>"
                                            value="<?php echo e($hotel ? $hotel->phone : old('phone')); ?>">
                                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Website:')); ?> </p>
                                        <input type="url" name="website" class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="<?php echo e(__('Website')); ?>"
                                            value="<?php echo e($hotel ? $hotel->website : old('website')); ?>">
                                        <?php $__errorArgs = ['website'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Description :')); ?> </p>
                                        <textarea class="form-control bapric_edittor" name="description"
                                            aria-label="With textarea" rows="5"
                                            placeholder="<?php echo e(__('Write description here...')); ?>"><?php echo clean($hotel ? $hotel->description : old('description')); ?></textarea>
                                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Rules :')); ?> </p>
                                        <textarea class="form-control bapric_edittor" name="rules"
                                            aria-label="With textarea" rows="5"
                                            placeholder="<?php echo e(__('Write rules here...')); ?>"><?php echo clean($hotel ? $hotel->rules : old('rules')); ?></textarea>
                                    </div>
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Hotel to stay title :')); ?> </p>
                                        <input type="text" name="hotel_to_stay_title" class="form-control"
                                            aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                            placeholder="<?php echo e(__('Hotel Location')); ?>"
                                            value="<?php echo e($hotel ? $hotel->hotel_to_stay_title : old('hotel_to_stay_title')); ?>">
                                    </div>
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Breakfast Info:')); ?> <span
                                                class="text-success"><?php echo e(__('(Add cuisine with comma)')); ?></span></p>
                                        <input type="text" name="breakfast_info" class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm"
                                            placeholder="<?php echo e(__('Breakfast Info')); ?>"
                                            value="<?php echo e($hotel ? $hotel->breakfast_info : old('breakfast_info')); ?>">

                                        <?php $__errorArgs = ['breakfast_info'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Lunch Info:')); ?> <span
                                                class="text-success"><?php echo e(__('(Add cuisine with comma)')); ?></span></p>
                                        <input type="text" name="lunch_info" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm"
                                               placeholder="<?php echo e(__('Lunch Info')); ?>"
                                               value="<?php echo e($hotel ? $hotel->lunch_info : old('lunch_info')); ?>">

                                        <?php $__errorArgs = ['lunch_info'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Dinner Info:')); ?> <span
                                                class="text-success"><?php echo e(__('(Add cuisine with comma)')); ?></span></p>
                                        <input type="text" name="dinner_info" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm"
                                               placeholder="<?php echo e(__('Dinner Info')); ?>"
                                               value="<?php echo e($hotel ? $hotel->dinner_info : old('dinner_info')); ?>">

                                        <?php $__errorArgs = ['dinner_info'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Hotel to stay Description :')); ?> </p>
                                        <textarea class="form-control bapric_edittor" name="hotel_to_stay_description"
                                            aria-label="With textarea" rows="5"
                                            placeholder="<?php echo e(__('Write description here...')); ?>"><?php echo clean($hotel ? $hotel->hotel_to_stay_description : old('hotel_to_stay_description')); ?></textarea>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <p class="mb-1"><?php echo e(__('Facility :')); ?></p>
                                        <select class="form-control form-control-lg multi_select" name="facilities[]"
                                            multiple="multiple">
                                            <?php $__currentLoopData = $facilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $facility): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option
                                                    <?php echo e($hotel && is_array($hotel_facilities) && in_array($facility->id, $hotel_facilities) ? 'selected' : ''); ?>

                                                    value="<?php echo e($facility->id); ?>"><?php echo e($facility->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['facilities'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <p class="mb-2 font-weight-bold"><?php echo e(__('Main Image :')); ?>

                                            <code><?php echo e(__('(Only jpeg, png, jpg and gif file is acceptable)')); ?></code>
                                        </p>
                                        <div class="mb-3">
                                            <div class="bg_image" id="bg_image">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        <?php $__errorArgs = ['bg_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <?php if($hotel): ?>
                                        <div class="pl-3 pr-2 ">
                                            <p class="mb-2 font-weight-bold "><?php echo e(__('Exists Main Image :')); ?> </p>
                                            <?php echo imageShow($hotel->hotel_primary_image, 'hotel image', 'img-thumbnail bg-secondary', 'width="200" height="100"',  'App\Models\Hotel', $hotel->id, 'hotel_primary_image'); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <p class="mb-2 font-weight-bold"><?php echo e(__('Feature Image :')); ?>

                                            <code><?php echo e(__('(Only jpeg, png, jpg and gif file is acceptable)')); ?></code>
                                        </p>
                                        <div class="mb-3">
                                            <div class="" id="feature_image">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        <?php $__errorArgs = ['feature_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <?php if($hotel): ?>
                                        <div class="pl-3 pr-2 ">
                                            <p class="mb-2 font-weight-bold "><?php echo e(__('Exists Feature Image :')); ?> </p>
                                            <?php echo imageShow(asset(UPLOAD_FOLDER_HOTELS . $hotel->feature_image), 'hotel feature image', 'img-thumbnail bg-secondary', 'width="200" height="100"',  'App\Models\Hotel', $hotel->id, 'feature_image'); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="col-sm-2">
                                    <p class="mb-2 font-weight-bold "><?php echo e(__('Is Private Parking?')); ?> </p>
                                    <label class="switch">
                                        <input type="checkbox" name="parking_info"
                                            <?php echo e($hotel && $hotel->parking_info == ACTIVE_STATUS ? 'checked' : ''); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                                <div class="col-sm-2">
                                    <p class="mb-2 font-weight-bold "><?php echo e(__('Status')); ?> </p>
                                    <label class="switch">
                                        <input type="checkbox" name="status"
                                            <?php echo e($hotel && $hotel->status == ACTIVE_STATUS ? 'checked' : ''); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer text-right">
                            <div class="wizard-action">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                    type="submit"><?php echo e(__('Submit & Next')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    <script src="<?php echo e(asset('backend/assets/plugin/select2/select2.min.js')); ?>"></script>
    <?php echo $__env->make('backend.pages.hotel.internal-assets.js.page-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.pages.delete-warning', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/hotel/form.blade.php ENDPATH**/ ?>