

<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>

<?php $__env->startSection('page-css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('frontend/plugins/sollist-master/sollist.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if($commentSettings): ?>
        <div class="d-none"><?php echo $commentSettings->code; ?></div>
    <?php endif; ?>

    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" style="<?php if(!empty($pageContent->bg_img)): ?>background-image: url(<?php echo e(asset($pageContent->bg_img)); ?>);<?php else: ?> background-image: url(<?php echo e(asset('frontend/images/bg/px-1.jpg')); ?>); <?php endif; ?>">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(clean($title ? $title : '')); ?></h4>
                        <p><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Home')); ?></a> <a
                                href="<?php echo e(route('blog')); ?>"><?php echo e(__('blog')); ?></a></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->
    <!-- Blog Section Start -->
    <section class="blog-section">
        <div class="container">
            <div class="row">
                <div class="col-md-8 col-lg-9">
                    <div class="blog-details">
                        <div class="details-thumb">
                            <?php echo imageShow($blog->bg_image, __('Blog Image')); ?>

                        </div>
                        <div class="details-content mb-40">
                            <h4><?php echo e(clean($blog ? $blog->title : '')); ?></h4>
                            <p class="mb-20"><?php echo clean($blog ? $blog->description : ''); ?></p>
                            <ul class="details-tag mb-40">
                                <li><a href="#"><i
                                            class="pe-7s-stopwatch"></i><?php echo e(date('d-M-Y', strtotime($blog->created_at))); ?></a>
                                </li>
                                <li><a href="#"><i class="pe-7s-user"></i><?php echo e(clean($blog->userId->name)); ?></a></li>
                                <li><a href="#"><i class="pe-7s-folder"></i><?php echo e(clean($blog->category->name)); ?></a></li>
                            </ul>
                            <?php echo $__env->make('frontend.share-link',['route'=>route('view-single-blog-page', $blog->slug)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <div class="btn-box mt-60">
                                <?php if($previous): ?><a class="float-left" href="<?php echo e(route('view-single-blog-page', ['slug' => $previous->slug])); ?>"><?php echo e(__('previous')); ?></a><?php endif; ?>
                                <?php if($next): ?><a class="float-right" href="<?php echo e(route('view-single-blog-page', ['slug' => $next->slug])); ?>"><?php echo e(__('next')); ?></a><?php endif; ?>
                            </div>
                        </div>

                        <!-- Blog Post Author -->
                        <div class="blog-admin mb-5">
                            <div class="blog-admin-desc">
                                <div class="clearfix">
                                    <h5><?php echo e($blog->userId->name); ?></h5>
                                </div>
                                <p class="mb-15"><?php echo e($blog->userId->about_me); ?></p>
                            </div>
                        </div>
                        <?php if($commentSettings->code): ?>
                            <!-- End Blog Post Author -->
                            <div class="mb-5">
                                <h4><?php echo e(__('Comments')); ?></h4>
                                <div class="border-style-2"></div>
                            </div>

                            <div class="fb-comments" data-href="<?php echo e(route('view-single-blog-page', $blog->slug)); ?>"
                                data-width="" data-numposts="5"></div>
                            <!-- Blog Comments -->
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="theme-sidebar">

                        <div class="widget search-sidebar">
                            <div class="title-box">
                                <h3><?php echo e(__('Search')); ?> <span><?php echo e(__('Here')); ?></span></h3>
                            </div>
                            <form action="<?php echo e(route('search-blog')); ?>" method="GET" class="search-box" role="search">
                                <div class="form-group">
                                    <input type="text" name="search" placeholder="Search" class="form-control">
                                    <i class="fa fa-search form-control-feedback search_btn"></i>
                                    <button type="submit" class="d-none"></button>
                                </div>
                            </form>
                        </div>

                        <?php if(!empty($categories)): ?>
                            <div class="widget">
                                <div class="title-box">
                                    <h3><?php echo e(__('Categories')); ?> <span></span></h3>
                                </div>
                                <div class="cat-item">
                                    <ul>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><a
                                                    href="<?php echo e(route('blog-category', $category->id)); ?>"><?php echo e($category->name); ?></a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if(!empty($recentBlogs)): ?>
                            <div class="widget">
                                <div class="title-box">
                                    <h3><?php echo e(__('Recent')); ?> <span><?php echo e(__('posts')); ?></span></h3>
                                </div>
                                <?php $__currentLoopData = $recentBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recentBlog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="blog-small-item">
                                        <?php echo imageShow($recentBlog->feature_img, __('Blog Image')); ?>

                                        <div class="tex">
                                            <h5><a
                                                    href="<?php echo e(route('view-single-blog-page', ['slug' => $recentBlog->slug])); ?>"><?php echo e(Str::limit($recentBlog ? $recentBlog->title : '',30)); ?></a>
                                            </h5>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($blogTags)): ?>
                            <div class="widget">
                                <div class="title-box">
                                    <h3><?php echo e(__('Tag ')); ?><span><?php echo e(__('Cloud')); ?></span></h3>
                                </div>
                                <div class="tags-item">
                                    <?php $__currentLoopData = $blogTags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blogTag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a
                                            href="<?php echo e(route('blog-tag', $blogTag->tag_id)); ?>"><?php echo e($blogTag->tag_name); ?></a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Blog Section End -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/frontend/pages/blog/singleBlog.blade.php ENDPATH**/ ?>