

<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>

<?php $__env->startSection('page-css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Inner Section Start -->
<section class="inner-area parallax-bg"
    style="<?php if(!empty($pageContent->bg_img)): ?>background-image: url(<?php echo e($pageContent->bg_img); ?>);<?php else: ?> background-image: url(<?php echo e(asset('frontend/images/bg/px-1.jpg')); ?>); <?php endif; ?>"
    data-type="parallax" data-speed="3">
    <div class="container">
        <div class="section-content">
            <div class="row">
                <div class="col-12">
                    <h4><?php echo e(isset($title) ? clean($title) : ''); ?></h4>
                    <p><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Home')); ?></a>
                        <a><?php echo e(isset($title) ? clean($title) : ''); ?></a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Inner Section End -->

<!-- Special Packages Section Start -->
<section class="special-packages-sec pt-85 pb-60">
    <div class="container">
        <div class="row grid-mb">
            <div class="col-md-12">
                <div class="special-packages dtl-st">
                    <div class="thumb">
                        <?php if(count($package->images)): ?>
                        <?php echo imageShow($package->images[0]->images, __('Tour Image'), ''); ?>

                        <?php endif; ?>

                        <?php if($discount): ?>
                        <div class="offer-price"> <?php echo e(__('Off')); ?> <?php echo e(discountPriceShow($discount)); ?></div>
                        <?php endif; ?>
                        <div class="post-title-box">
                            <div class="price-box">
                                <h5><?php echo e($sub_price ? discountPriceCalculate($sub_price[0]->tour_price, $discount)['price'] :
                                    'Unknown'); ?>

                                </h5>
                                <h6><?php echo e(__('Starts From')); ?></h6>
                            </div>
                            <div class="title-box">
                                <div class="row">
                                    <div class="col-md-8">
                                        <h4><?php echo e(clean($package?$package->title:'')); ?></h4>
                                        <h3><?php echo e(clean($package?$package->location:'')); ?></h3>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="row">
                                            <div class="col-md-8 pt-2">
                                                <h5 class="btn text-white pl-100"><i
                                                        class="fa fa-share-alt pt-2 pb-2 text-danger"
                                                        data-toggle="dropdown" aria-expanded="false"></i>
                                                    <div class="dropdown-menu">
                                                        <?php echo $__env->make('frontend.share-link',['route'=>route('package.details',
                                                        $package->id)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                    </div>
                                                </h5>
                                            </div>
                                            <div class="col-md-4 pt-2">
                                                <a class="btn btn-primary scroll_to_div" data-id="group_price_section"
                                                    href="javascipt:void()"><?php echo e(__('Booking Now')); ?></a>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="content">
                        <ul class="info">
                            <li><a><i class="fa fa-calendar"></i><?php echo e($package->day); ?>

                                    <?php echo e(__('Days')); ?></a></li>
                            <li><a><i class="fa fa-user"></i><?php echo e($sub_price ? $sub_price[0]->group_size : ''); ?></a>
                            </li>
                            <?php if($package->tour_map_image): ?>
                            <li><a class="package_map" href="#package_map_modal" data-toggle="modal"
                                    data-name="<?php echo e($package->title); ?>"
                                    data-image="<?php echo e(imageShow($package->tour_map_image, 'Package Image')); ?>"><i
                                        class="fa fa-map-marker"></i><?php echo e(__('View Map Image')); ?></a>
                            </li>
                            <?php endif; ?>
                        </ul>
                        <p><?php echo e($package->description); ?></p>
                        <div class="row">
                            <?php $__currentLoopData = $package->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-6">
                                <?php echo imageShow($image->images, __('Tour Image'), ''); ?>

                            </div>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="inner-title mt-25">
                            <h2><?php echo e(__('Tour Highlight')); ?></h2>
                            <div class="mb-40"><?php echo e(clean($package?$package->tour_highlight:'')); ?></div>
                        </div>
                        <div class="inner-title mt-25">
                            <h2><?php echo e(__('Tour Itineraries')); ?></h2>
                            <div class="mb-40"><?php echo e(clean($package?$package->tour_itineraries:'')); ?></div>
                        </div>

                        <?php
                        $map_iamge = imageShow($package->tour_map_image, __('Tour Map Image'), 'mw-50');
                        ?>

                        <?php if($map_iamge): ?>
                        <div class="inner-title mt-25">
                            <h2><?php echo e(__('Tour Map')); ?></h2>
                            <div class="mb-40">
                                <?php echo $map_iamge; ?>

                            </div>
                        </div>
                        <?php endif; ?>

                        <div class="inner-title mt-25" id="group_price_section">
                            <h2><?php echo e(__('Sub Price')); ?></h2>
                            <div class="mb-40">
                                <table class="table table-striped  table-bordered">
                                    <thead>
                                        <tr>
                                            <th><?php echo e(__('Group Size')); ?></th>
                                            <th width="12%"><?php echo e(__('Price')); ?>

                                                <?php if($discount): ?>
                                                <span class="small mt-0"><?php echo e(__('(Discounted)')); ?></span>
                                                <?php endif; ?>
                                            </th>
                                            <th width="16%"><?php echo e(__('Booking')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $sub_price; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="pt-4 pl-4"><?php echo e($price->group_size); ?></td>
                                            <td class="text-center pt-4"><?php echo e(discountPriceCalculate($price->tour_price, $discount)['price']); ?></td>
                                            <td>
                                                <a class="btn-theme"
                                                    href="<?php echo e(route('booking.package', ['package_id' => $package->id, 'group_id' => $price->id])); ?>"><?php echo e(__('Booking Now')); ?></a>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="inner-title mt-25">
                            <h2><?php echo e(__('Inclusion and Exclusion')); ?></h2>
                            <h4><?php echo e(__('Inclusion')); ?></h4>
                            <div class="mb-40 ml-4"><?php echo clean($package?$package->inclusion:''); ?> </div>
                            <h4><?php echo e(__('Exclusion')); ?></h4>
                            <div class="mb-40 ml-4"><?php echo clean($package?$package->exclusion:''); ?> </div>
                        </div>
                        <div class="inner-title mt-25">
                            <h2><?php echo e(__('Important notes')); ?></h2>
                            <div class="mb-40 ml-4"><?php echo clean($package?$package->notes:''); ?> </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Special Packages Section End -->

<?php if($latestPackage): ?>
<!-- Global Section Start -->
<section class="global-section over-layer-white pt-10 pb-70">

    <div class="container">
        <div class="inner-title mt-25 text-center pb-20">
            <h2><?php echo e(__('Latest Packages')); ?></h2>
            <p><?php echo e(__('Here you choose your place that\'s special and you want to go')); ?></p>
        </div>
        <div class="row">
            <div class=" specialplaces_carousel owl-carousel owl-theme owl-navst st-two">
                <?php $__currentLoopData = $latestPackage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $place_package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                $discount = $place_package->discount ? $place_package->discount->discount : null;
                $subprices = $place_package->subprice ? $place_package->subprice : null;
                ?>
                <div class="item">
                    <div class="special-places">
                        <?php if(count($place_package->images)): ?>
                        <div class="thumb">
                            <?php echo imageShow($place_package->images[0]->images, 'upload/pkg_image/', __('Tour Image'), ''); ?>

                        </div>
                        <?php endif; ?>

                        <div class="content">
                            <div class="price-box">
                                <h5><?php echo e($subprices[0] ? discountPriceCalculate($subprices[0]->tour_price, $discount)['price'] : ''); ?>

                                </h5>
                                </h5>
                                <h6><?php echo e(__('Starts From')); ?></h6>
                            </div>
                            <div class="title-box">
                                <h4><?php echo e($place_package->title); ?></h4>
                                <h3><?php echo e($place_package->location); ?></h3>
                            </div>
                            <ul class="info">
                                <li><span><i class="fa fa-calendar"></i><?php echo e($place_package->day); ?>

                                        <?php echo e(__('Days')); ?></span>
                                </li>
                                <li><span><i class="fa fa-user"></i><?php echo e($subprices && $subprices[0] ?
                                        $subprices[0]->group_size : ''); ?></span>
                                </li>
                                <?php if($place_package->tour_map_image): ?>
                                <li><a class="package_map" href="#package_map_modal" data-toggle="modal"
                                        data-name="<?php echo e($place_package->title); ?>"
                                        data-image="<?php echo e(imageShow($place_package->tour_map_image, 'Package Image')); ?>"><i
                                            class="fa fa-map-marker"></i><?php echo e(__('View Map Image')); ?></a>
                                </li>
                                <?php endif; ?>
                            </ul>
                            <p><?php echo e(clean(Str::limit($place_package ? $place_package->description : '',135))); ?>

                            </p>
                            <h5 class="share-btn"><i class="fa fa-share-alt" data-toggle="dropdown"
                                    aria-expanded="false"></i>
                                <div class="dropdown-menu">
                                    <?php echo $__env->make('frontend.share-link',['route'=>route('package.details',
                                    $place_package->id)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </h5>
                            <a class="btn-theme" href="<?php echo e(route('package.details', $place_package->id)); ?>"><?php echo e(__('View
                                Details')); ?></a>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

        </div>
    </div>
</section>
<!-- Global Section End -->

<?php endif; ?>


<?php echo $__env->make('frontend.pages.packages.map-image-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
<script src="<?php echo e(asset('frontend/js/jquery.fancybox.js')); ?>"></script>
<?php echo $__env->make('frontend.scripts.package-map-script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/frontend/pages/packages/singlePackage.blade.php ENDPATH**/ ?>