

<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>

<?php $__env->startSection('page-css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" <?php if(!empty($pageContent->bg_img)): ?>style="background-image: url(<?php echo e(asset($pageContent->bg_img)); ?>);<?php else: ?> background-image: url(<?php echo e(asset('frontend/images/bg/px-1.jpg')); ?>);" <?php endif; ?>>
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(isset($title) ? clean($title) : ''); ?></h4>
                        <p><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Home')); ?></a>
                            <a><?php echo e(isset($title) ? clean($title) : ''); ?></a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    <?php if($about_section): ?>
        <!-- Global Section Start -->
        <section class="global-section over-layer-white pt-80 pb-70">
            <div class="container">
                <div class="row">
                    <div class="col-xl-7 col-lg-12">
                        <div class="global-area">
                            <div class="inner-title">
                                <h2><?php echo e(clean($about_section ? $about_section->title : '')); ?></h2>
                                <h3><?php echo e(clean($about_section ? $about_section->sub_title : '')); ?></h3>
                                <div class="sec-line"></div>
                            </div>
                            <?php echo clean($about_section ? $about_section->description : ''); ?>

                        </div>
                    </div>
                    <div class="col-xl-5 col-lg-8 col-md-10">
                        <div class="map-area">
                            <img src="<?php echo e($about_section_right ? $about_section_right->fnt_img : ''); ?>" alt="image">
                        </div>
                        <p class="map-content">
                            <?php echo e(clean($about_section_right ? $about_section_right->about_image_phone : '')); ?>

                        </p>
                    </div>
                </div>
            </div>
        </section>
        <!-- Global Section End -->
    <?php endif; ?>


    <?php if($about_feature): ?>
        <!-- Features Section Start -->
        <section class="feature-section over-layer-black pt-85 pb-90" style="<?php if(!empty($about_feature->bg_img)): ?>background-image: url(<?php echo e($about_feature->bg_img); ?>);<?php else: ?> background-image: url(<?php echo e(asset('frontend/images/bg/px-1.jpg')); ?>); <?php endif; ?>">
            <div class="container">
                <div class="row">
                    <div class="section-title">
                        <h4><?php echo e(clean($about_feature ? $about_feature->title : '')); ?></h4>
                        <h2><?php echo e(clean($about_feature ? $about_feature->sub_title : '')); ?></h2>
                        <?php echo clean($about_feature ? $about_feature->description : ''); ?>

                    </div>
                </div>
                <div class="row">
                    <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4">
                            <div class="feature-item">
                                <div class="icon-box">
                                    <?php echo clean($feature ? $feature->icon : ''); ?>

                                </div>
                                <div class="content">
                                    <h3><?php echo e(clean($feature ? $feature->title : '')); ?></h3>
                                    <p><?php echo e(clean($feature ? $feature->description : '')); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
        <!-- Feature Section End -->
    <?php endif; ?>


    <?php if($about_team_section): ?>
        <!-- Team Section Start -->
        <section class="team-section bg-f8">
            <div class="container">
                <div class="row">
                    <div class="section-title">
                        <h4><?php echo e(clean($about_team_section ? $about_team_section->title : '')); ?></h4>
                        <h2><?php echo e(clean($about_team_section ? $about_team_section->sub_title : '')); ?></h2>
                        <p><?php echo e(clean($about_team_section ? $about_team_section->description : '')); ?></p>
                    </div>
                </div>
                <div class="row">
                    <?php $__currentLoopData = $teamMembers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teamMember): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-3 col-md-4 col-sm-6">
                            <div class="team-col">
                                <div class="thumb">
                                    <?php echo imageShow($teamMember->image, __('Team photo')); ?>

                                </div>
                                <div class="content text-center">
                                    <h4><a href="#"><?php echo e(clean($teamMember ? $teamMember->name : '')); ?></a></h4>
                                    <h5><?php echo e(clean($teamMember ? $teamMember->designation->name : '')); ?></h5>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
        <!-- Team Section End -->
    <?php endif; ?>


    <!-- Funfact Section Start -->

    <?php if($award_setting): ?>
        <!-- Funfact Section Start -->
        <section class="funfact-section over-layer-black pt-90 pb-60">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="video-sec">
                            <h2><?php echo e(clean($award_setting ? $award_setting->title : '')); ?></h2>
                            <p><?php echo e(clean($award_setting ? $award_setting->sub_title : '')); ?></p>
                            <div class="video-content">
                                <?php echo imageShow($award_setting->fnt_img, __('Award Image')); ?>

                                <?php if($award_setting->youtube_url): ?>
                                    <div class="overlay">
                                        <a href="<?php echo e($award_setting->youtube_url); ?>" class="popup-youtube"><i
                                                class="ficon fa fa-play-circle"></i></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <?php echo clean($award_setting ? $award_setting->description : ''); ?>

                    </div>
                </div>
            </div>
        </section>
        <!-- Funfact Section End -->
    <?php endif; ?>

    <?php if($about_client_section): ?>
        <!-- Testimonials Section Start -->
        <section class="testimonials-section pt-80 pb-80">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="inner-title">
                            <h2><?php echo e(clean($about_client_section ? $about_client_section->title : '')); ?></h2>
                            <div class="sec-line mb-40"></div>
                        </div>
                        <div class="testimonials-post testimonials_slide_col_two owl-carousel owl-theme owl-navst st-three">
                            <?php $__currentLoopData = $aboutClients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aboutClient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="testimonials-item">
                                    <div class="thumb">
                                        <?php echo imageShow($aboutClient->image, __('Client photo')); ?>

                                    </div>
                                    <div class="content">
                                        <h5><?php echo e(clean($aboutClient ? $aboutClient->name : '')); ?> <small>-
                                                <?php echo e(clean($aboutClient ? $aboutClient->designation : '')); ?></small></h5>
                                        <?php echo ratingShow($aboutClient->rating); ?>

                                        <p><i
                                                class="fa fa-quote-left"></i><?php echo e($aboutClient ? $aboutClient->testimonial : ''); ?>

                                        </p>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Testimonials Section End -->
    <?php endif; ?>


    <?php if($about_blog_section): ?>
        <!-- Blog Section Start -->
        <section class="blog-section bg-f8 pt-85 pb-55">
            <div class="container">
                <div class="row">
                    <div class="section-title">
                        <h4><?php echo e(clean($about_blog_section ? $about_blog_section->title : '')); ?></h4>
                        <h2><?php echo e(clean($about_blog_section ? $about_blog_section->sub_title : '')); ?></h2>
                        <p><?php echo e(clean($about_blog_section ? $about_blog_section->description : '')); ?></p>
                    </div>
                </div>
                <div class="row">
                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 col-lg-4">
                            <div class="blog-post">
                                <div class="thumb">
                                    <?php echo imageShow($blog->feature_img, __('Blog Image')); ?>

                                    <div class="content">
                                        <h3><?php echo e($blog ? $blog->title : ''); ?></h3>
                                        <div class="meta-box">
                                            <div class="admin-post"> <?php echo e(__('Admin, TributeTheme')); ?> </div>
                                            <div class="inner">
                                                <div class="date">
                                                    <i class="fa fa-calendar-plus-o"></i>
                                                    <?php echo e(date('M', strtotime($blog->created_at))); ?>

                                                    <b><?php echo e(date('d', strtotime($blog->created_at))); ?></b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <a href="<?php echo e(route('view-single-blog-page', ['slug' => $blog->slug])); ?>"
                                    class="read-btn"><?php echo e(__('Continue
                                                                                                                                                                                                        Reading')); ?>

                                    <i class="fa fa-long-arrow-right" aria-hidden="true"></i>
                                </a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </section>
        <!-- Blog Section End -->
    <?php endif; ?>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/frontend/pages/about-us/index.blade.php ENDPATH**/ ?>