<script>

    (function ($) {

        "use strict";

        $('.admin-image').imageUploader({
            imagesInputName: 'photo',
            maxFiles: 1,
        });
        $('#deleteAccountBtn').on('click', function(){
            deleteAccountAlert();
        });

        function deleteAccountAlert() {
            swal({
                title: "<?php echo e(__('Are you sure?')); ?>",
                text: "<?php echo e(__('Are you sure you want to delete your account? Once your account is deleted, all of its resources and data will be permanently deleted. Please enter your password to confirm you would like to permanently delete your account.')); ?>",
                icon: "warning",
                dangerMode: true,
                content: {
                    element: "input",
                    attributes: {
                        placeholder: "<?php echo e(__('Type your password')); ?>",
                        type: "password",
                        required: true,
                    },
                },
                buttons: {
                    cancel: true,
                    confirm: {
                        text: "<?php echo e(__('OK')); ?>",
                        value: true,
                        visible: true,
                        closeModal: true
                    },
                },
            }).then((value) => {
                if(value == ''){
                    swal(`You don\'t input your password.`,{
                        icon: "error",
                        dangerMode: true,
                    }).then(() => {
                        deleteAccountAlert();
                    });
                }else if(value){
                    document.getElementById('deleteForm').querySelector('input[name="password"]').value = value;
                    swal(`Your request has been processing.`,{
                        icon: "success",
                        dangerMode: true,
                    });
                    document.getElementById('deleteForm').submit();
                }
            });
        }

    })(jQuery);


</script>
<?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/profile/internal-assets/js/profile-page-scripts.blade.php ENDPATH**/ ?>