
<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>
<?php $__env->startSection('page-css'); ?>
    <link href="<?php echo e(asset('backend/assets/plugin/select2/select2.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a>
                    <span class="breadcrumb-item active"><?php echo e(__($title)); ?></span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <h6 class="card-title lh-35"><?php echo e(__($title)); ?></h6>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <form action="<?php echo e(route('admin.hotel.image.index')); ?>" method="get">
                                    <select id="hotel_list" name="hotel_id" class="form-control single_select">
                                        <option></option>
                                        <?php if(count($hotels)): ?>
                                            <?php $__currentLoopData = $hotels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hotel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option
                                                <?php echo e($hotel_id && $hotel_id == $hotel->id ? 'selected' : ''); ?> value="<?php echo e($hotel->id); ?>"><?php echo e($hotel->hotel_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                </form>
                            </div>
                            <div class="col-md-2 col-sm-12 text-right">
                                <a href="<?php echo e(route('admin.hotel.image.create')); ?>" class="btn btn-danger btn-sm rounded"><i
                                        class="material-icons"><?php echo e(__("add")); ?></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example" class="table bapric_table data-table table-striped table-bordered miw-500"
                                cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th width="10%"><?php echo e(__('SL')); ?></th>
                                        <th width="100"><?php echo e(__('Image')); ?></th>
                                        <th><?php echo e(__('Hotel Name')); ?></th>
                                        <th width="10%"><?php echo e(__('Action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody id="hotel_images">
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    <script src="<?php echo e(asset('backend/assets/plugin/select2/select2.min.js')); ?>"></script>
    <?php echo $__env->make('backend.pages.hotel-image.internal-assets.js.delete-warning', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.pages.hotel-image.internal-assets.js.page-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.pages.hotel-image.internal-assets.js.datatable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/hotel-image/index.blade.php ENDPATH**/ ?>